/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.api.recipes.cache.PlantingCacheRecipe;
import com.jerry.mekmm.api.recipes.outputs.MoreMachineOutputHelper;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.upgrade.PlantingUpgradeData;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPlantingStation
extends TileEntityProgressMachine<PlantingRecipe>
implements IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, PlantingRecipe>,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int BASE_TICKS_REQUIRED = 200;
    public static final long MAX_GAS = 210L;
    private final ItemStackConstantChemicalToItemStackCachedRecipe.ChemicalUsageMultiplier gasUsageMultiplier;
    private long baseTotalUsage;
    private long usedSoFar;
    public IGasTank gasTank;
    protected final IOutputHandler<PlantingRecipe.PlantingStationRecipeOutput> outputHandler;
    protected final IInputHandler<@NotNull ItemStack> itemInputHandler;
    protected final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityPlantingStation> energyContainer;
    InputInventorySlot inputSlot;
    OutputInventorySlot mainOutputSlot;
    OutputInventorySlot secondaryOutputSlot;
    GasInventorySlot gasSlot;
    EnergyInventorySlot energySlot;

    public TileEntityPlantingStation(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.PLANTING_STATION, pos, state, TRACKED_ERROR_TYPES, 200);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY});
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.inputSlot, (IInventorySlot)this.mainOutputSlot, (IInventorySlot)this.gasSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupItemIOConfig(Collections.singletonList(this.inputSlot), List.of(this.mainOutputSlot, this.secondaryOutputSlot), (IInventorySlot)this.energySlot, false);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.gasTank, RelativeSide.RIGHT).setCanEject(false);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.gasInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.gasTank);
        this.outputHandler = MoreMachineOutputHelper.getOutputHandler((IInventorySlot)this.mainOutputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, (IInventorySlot)this.secondaryOutputSlot, NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR);
        this.baseTotalUsage = this.baseTicksRequired;
        this.gasUsageMultiplier = (usedSoFar, operatingTicks) -> {
            long baseRemaining = this.baseTotalUsage - usedSoFar;
            int remainingTicks = this.getTicksRequired() - operatingTicks;
            if (baseRemaining < (long)remainingTicks) {
                return 0L;
            }
            if (baseRemaining == (long)remainingTicks) {
                return 1L;
            }
            return Math.max(MathUtils.clampToLong((double)((double)baseRemaining / (double)remainingTicks)), 0L);
        };
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityPlantingStation)this).getDirection(), () -> ((TileEntityPlantingStation)this).getConfig());
        this.gasTank = (IGasTank)ChemicalTankBuilder.GAS.create(210L, ChemicalTankBuilder.GAS.alwaysTrueBi, (gas, automationType) -> this.containsRecipeBA(this.inputSlot.getStack(), (Chemical)gas), arg_0 -> ((TileEntityPlantingStation)this).containsRecipeB(arg_0), recipeCacheListener);
        builder.addTank((IChemicalTank)this.gasTank);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityPlantingStation)this).getDirection(), () -> ((TileEntityPlantingStation)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityPlantingStation)this).getDirection(), () -> ((TileEntityPlantingStation)this).getConfig());
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, (GasStack)this.gasTank.getStack()), arg_0 -> ((TileEntityPlantingStation)this).containsRecipeA(arg_0), (IContentsListener)recipeCacheListener, (int)56, (int)17);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.gasSlot = GasInventorySlot.fillOrConvert((IGasTank)this.gasTank, () -> ((TileEntityPlantingStation)this).m_58904_(), (IContentsListener)listener, (int)56, (int)53);
        builder.addSlot((IInventorySlot)this.gasSlot);
        this.mainOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)116, (int)35);
        builder.addSlot((IInventorySlot)this.mainOutputSlot);
        this.secondaryOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)132, (int)35);
        builder.addSlot((IInventorySlot)this.secondaryOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPlantingStation)this).m_58904_(), (IContentsListener)listener, (int)31, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected boolean useStatisticalMechanics() {
        return false;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasSlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @NotNull
    public IMekanismRecipeTypeProvider<PlantingRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, PlantingRecipe>> getRecipeType() {
        return (IMekanismRecipeTypeProvider)MoreMachineRecipeType.PLANTING.get();
    }

    @Nullable
    public PlantingRecipe getRecipe(int cacheIndex) {
        return (PlantingRecipe)this.findFirstRecipe((IInputHandler)this.itemInputHandler, (IInputHandler)this.gasInputHandler);
    }

    @NotNull
    public CachedRecipe<PlantingRecipe> createNewCachedRecipe(@NotNull PlantingRecipe recipe, int cacheIndex) {
        return PlantingCacheRecipe.create(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.gasInputHandler, this.gasUsageMultiplier, used -> {
            this.usedSoFar = used;
        }, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityPlantingStation)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityPlantingStation)this).getTicksRequired()).setOnFinish(() -> ((TileEntityPlantingStation)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    public MachineEnergyContainer<TileEntityPlantingStation> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean isConfigurationDataCompatible(BlockEntityType<?> tileType) {
        return super.isConfigurationDataCompatible(tileType) || MoreMachineUtils.isSameMMTypeFactory(this.getBlockType(), tileType);
    }

    @Nullable
    public PlantingUpgradeData getUpgradeData() {
        return new PlantingUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.getOperatingTicks(), this.usedSoFar, this.gasTank, this.energySlot, this.gasSlot, this.inputSlot, this.mainOutputSlot, this.secondaryOutputSlot, (List<ITileComponent>)this.getComponents());
    }

    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.usedSoFar = nbt.m_128454_("usedSoFar");
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128356_("usedSoFar", this.usedSoFar);
    }
}

