/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.ReplicatorIRecipe;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineGas;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityReplicator
extends TileEntityProgressMachine<ItemStackGasToItemStackRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int BASE_TICKS_REQUIRED = 200;
    public static final long MAX_GAS = 10000L;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.itemReplicatorRecipe.get());
    public IGasTank gasTank;
    private MachineEnergyContainer<TileEntityReplicator> energyContainer;
    protected final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IOutputHandler<ItemStack> outputHandler;
    private final ILongInputHandler<GasStack> gasInputHandler;
    InputInventorySlot inputSlot;
    OutputInventorySlot outputSlot;
    GasInventorySlot gasSlot;
    EnergyInventorySlot energySlot;

    public TileEntityReplicator(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.REPLICATOR, pos, state, TRACKED_ERROR_TYPES, 200);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY});
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.inputSlot, (IInventorySlot)this.outputSlot, (IInventorySlot)this.gasSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.configComponent.setupInputConfig(TransmissionType.GAS, (Object)this.gasTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.gasInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.gasTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IInventorySlot)this.outputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @Nullable
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityReplicator)this).getDirection(), () -> ((TileEntityReplicator)this).getConfig());
        this.gasTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L, TileEntityReplicator::isValidGasInput, recipeCacheListener);
        builder.addTank((IChemicalTank)this.gasTank);
        return builder.build();
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityReplicator)this).getDirection(), () -> ((TileEntityReplicator)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityReplicator)this).getDirection(), () -> ((TileEntityReplicator)this).getConfig());
        this.inputSlot = InputInventorySlot.at(TileEntityReplicator::isValidItemInput, (IContentsListener)recipeCacheListener, (int)29, (int)32);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)131, (int)32);
        ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE)));
        this.gasSlot = GasInventorySlot.fillOrConvert((IGasTank)this.gasTank, () -> ((TileEntityReplicator)this).m_58904_(), (IContentsListener)listener, (int)8, (int)65);
        builder.addSlot((IInventorySlot)this.gasSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityReplicator)this).m_58904_(), (IContentsListener)listener, (int)152, (int)65);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.gasSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    public static boolean isValidGasInput(Gas gas) {
        return gas.equals(MoreMachineGas.UU_MATTER.getChemical());
    }

    public static boolean isValidItemInput(ItemStack stack) {
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Item)stack.m_41720_())).toString());
        }
        return false;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasSlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Nullable
    public MachineEnergyContainer<TileEntityReplicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ItemStackGasToItemStackRecipe, ?> getRecipeType() {
        return null;
    }

    @Nullable
    public ItemStackGasToItemStackRecipe getRecipe(int cacheIndex) {
        return TileEntityReplicator.getRecipe((ItemStack)this.itemInputHandler.getInput(), (GasStack)this.gasInputHandler.getInput());
    }

    public static ItemStackGasToItemStackRecipe getRecipe(ItemStack itemStack, GasStack gasStack) {
        if (gasStack.isEmpty() || itemStack.m_41619_()) {
            return null;
        }
        if (customRecipeMap != null) {
            Item item = itemStack.m_41720_();
            int amount = customRecipeMap.getOrDefault(RegistryUtils.getName((Item)item).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new ReplicatorIRecipe(item, IngredientCreatorAccess.item().from(item, 1), (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from(MoreMachineGas.UU_MATTER, (long)amount), new ItemStack((ItemLike)item, 1));
        }
        return null;
    }

    @NotNull
    public CachedRecipe<ItemStackGasToItemStackRecipe> createNewCachedRecipe(@NotNull ItemStackGasToItemStackRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.itemReplicator(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.gasInputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityReplicator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityReplicator)this).getTicksRequired()).setOnFinish(() -> ((TileEntityReplicator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    public boolean isConfigurationDataCompatible(BlockEntityType<?> type) {
        return super.isConfigurationDataCompatible(type) || MoreMachineUtils.isSameMMTypeFactory(this.getBlockType(), type);
    }

    @Nullable
    public AdvancedMachineUpgradeData getUpgradeData() {
        return new AdvancedMachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), 0L, this.gasTank, this.gasSlot, this.energySlot, this.inputSlot, this.outputSlot, this.getComponents());
    }
}

