/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.imp;

import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import com.jerry.datagen.common.recipe.builder.MekMMDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.imp.MoreMachineRecipeProvider;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.block.attribute.MMAttributeFactoryType;
import com.jerry.mekmm.common.block.prefab.MMBlockFactoryMachine;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import com.jerry.mekmm.common.item.block.machine.ItemBlockMoreMachineFactory;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

class MMFactoryRecipeProvider
implements ISubRecipeProvider {
    MMFactoryRecipeProvider() {
    }

    @Override
    public void addRecipes(RecipeOutput consumer, HolderLookup.Provider registries) {
        String basePath = "factory/";
        String basicPath = basePath + "basic/";
        String advancedPath = basePath + "advanced/";
        String elitePath = basePath + "elite/";
        String ultimatePath = basePath + "ultimate/";
        TagKey osmiumIngot = (TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.OSMIUM);
        for (MoreMachineFactoryType type : MoreMachineEnumUtils.MM_FACTORY_TYPES) {
            BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, ItemBlockMoreMachineFactory> basicFactory = MoreMachineBlocks.getMMFactory(FactoryTier.BASIC, type);
            BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, ItemBlockMoreMachineFactory> advancedFactory = MoreMachineBlocks.getMMFactory(FactoryTier.ADVANCED, type);
            BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, ItemBlockMoreMachineFactory> eliteFactory = MoreMachineBlocks.getMMFactory(FactoryTier.ELITE, type);
            this.addFactoryRecipe(consumer, basicPath, basicFactory, (Holder<Item>)type.getBaseBlock().getItemHolder(), (TagKey<Item>)Tags.Items.INGOTS_IRON, (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC, (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC);
            this.addFactoryRecipe(consumer, advancedPath, advancedFactory, (Holder<Item>)basicFactory.getItemHolder(), (TagKey<Item>)osmiumIngot, (TagKey<Item>)MekanismTags.Items.ALLOYS_INFUSED, (TagKey<Item>)MekanismTags.Items.CIRCUITS_ADVANCED);
            this.addFactoryRecipe(consumer, elitePath, eliteFactory, (Holder<Item>)advancedFactory.getItemHolder(), (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)MekanismTags.Items.ALLOYS_REINFORCED, (TagKey<Item>)MekanismTags.Items.CIRCUITS_ELITE);
            this.addFactoryRecipe(consumer, ultimatePath, MoreMachineBlocks.getMMFactory(FactoryTier.ULTIMATE, type), (Holder<Item>)eliteFactory.getItemHolder(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC, (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE);
        }
    }

    private void addFactoryRecipe(RecipeOutput consumer, String basePath, BlockRegistryObject<MMBlockFactoryMachine.MMBlockFactory<?>, ?> factory, Holder<Item> toUpgrade, TagKey<Item> ingotTag, TagKey<Item> alloyTag, TagKey<Item> circuitTag) {
        MekMMDataShapedRecipeBuilder.shapedRecipe(factory).pattern(MoreMachineRecipeProvider.TIER_PATTERN).key('P', (ItemLike)toUpgrade.value()).key('C', circuitTag).key('I', ingotTag).key('A', alloyTag).build(consumer, Mekmm.rl(basePath + ((MMAttributeFactoryType)Attribute.getOrThrow(factory, MMAttributeFactoryType.class)).getMMFactoryType().getRegistryNameComponent()));
    }
}

