/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekaf.common.block.prefab.BlockAdvancedFactoryMachine;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.item.block.machine.AdvancedItemBlockFactory;
import com.jerry.mekaf.common.registries.AdvancedFactoryBlocks;
import com.jerry.mekaf.common.tile.factory.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.tile.factory.TileEntityCentrifugingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityChemicalInfusingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityCrystallizingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityDissolvingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityLiquifyingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityOxidizingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityPressurizedReactingFactory;
import com.jerry.mekaf.common.tile.factory.TileEntityWashingFactory;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedFactoryTileEntityTypes {
    public static final TileEntityTypeDeferredRegister AF_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekmm");
    private static final Table<FactoryTier, AdvancedFactoryType, TileEntityTypeRegistryObject<? extends TileEntityAdvancedFactoryBase<?>>> AF_FACTORIES = HashBasedTable.create();

    private AdvancedFactoryTileEntityTypes() {
    }

    private static void registerFactory(FactoryTier tier, AdvancedFactoryType type, AdvancedBlockEntityFactory<? extends TileEntityAdvancedFactoryBase<?>> factoryConstructor) {
        BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, AdvancedItemBlockFactory> block = AdvancedFactoryBlocks.getAdvancedFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = AF_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (TileEntityAdvancedFactoryBase)((Object)((Object)factoryConstructor.create((Holder<Block>)block, pos, state)))).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        AF_FACTORIES.put((Object)tier, (Object)type, (Object)tileRO);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityAdvancedFactoryBase<?>> getAdvancedFactoryTile(FactoryTier tier, AdvancedFactoryType type) {
        return (TileEntityTypeRegistryObject)AF_FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityAdvancedFactoryBase<?>>[] getFactoryTiles() {
        return AF_FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.OXIDIZING, TileEntityOxidizingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.DISSOLVING, TileEntityDissolvingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.CHEMICAL_INFUSING, TileEntityChemicalInfusingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.WASHING, TileEntityWashingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.PRESSURISED_REACTING, TileEntityPressurizedReactingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.CRYSTALLIZING, TileEntityCrystallizingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.CENTRIFUGING, TileEntityCentrifugingFactory::new);
            AdvancedFactoryTileEntityTypes.registerFactory(tier, AdvancedFactoryType.LIQUIFYING, TileEntityLiquifyingFactory::new);
        }
    }

    @FunctionalInterface
    private static interface AdvancedBlockEntityFactory<BE extends BlockEntity> {
        public BE create(Holder<Block> var1, BlockPos var2, BlockState var3);
    }
}

