/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.render.tileentity;

import com.google.common.collect.Table;
import com.jerry.mekmm.client.render.RenderLineHelper;
import com.jerry.mekmm.common.tile.TileEntityWirelessTransmissionStation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.joml.Vector3f;

@NothingNullByDefault
public class RenderWirelessTransmissionStation
extends MekanismTileEntityRenderer<TileEntityWirelessTransmissionStation> {
    public RenderWirelessTransmissionStation(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityWirelessTransmissionStation tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        BlockPos from = tile.getBlockPos();
        Vector3f start = new Vector3f((float)from.getX(), (float)(from.getY() + 3), (float)from.getZ());
        RenderLineHelper.renderLine(matrix, renderer, start, new Vector3f((float)from.getX(), (float)(from.getY() + 4), (float)from.getZ()), 48.0f, 255.0f, 249.0f, 1.0f);
        ArrayList<BlockPos> to = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Table<Direction, TransmissionType, BlockCapabilityCache<IChemicalHandler, Direction>>> entry : tile.chemicalCapabilityCache.entrySet()) {
            to.add(entry.getKey());
        }
        Level level = tile.getLevel();
        for (BlockPos toPos : to) {
            if (level == null || !level.isClientSide || toPos == null) continue;
            Vector3f end = new Vector3f((float)toPos.getX(), (float)toPos.getY(), (float)toPos.getZ());
            RenderLineHelper.renderLine(matrix, renderer, start, end, 48.0f, 255.0f, 249.0f, 1.0f);
        }
    }

    protected String getProfilerSection() {
        return "wirelessTransmissionStation";
    }
}

