/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.item;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.api.MoreMachineItemAbilities;
import com.jerry.mekmm.common.MoreMachineLang;
import com.jerry.mekmm.common.registries.MoreMachineDataComponents;
import com.jerry.mekmm.common.tile.TileEntityWirelessTransmissionStation;
import com.jerry.mekmm.common.tile.interfaces.ITileConnect;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.radial.IRadialModeItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConnector
extends Item
implements IRadialModeItem<ConnectorMode> {
    private static final Lazy<RadialData<ConnectorMode>> LAZY_RADIAL_DATA = Lazy.of(() -> IRadialDataHelper.INSTANCE.dataForEnum(Mekmm.rl("connector_mode"), ConnectorMode.class));

    public ItemConnector(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).stacksTo(1).component(MoreMachineDataComponents.CONNECTOR_MODE, (Object)ConnectorMode.CONNECT_ENERGY));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)MekanismLang.STATE.translateColored(EnumColor.PINK, new Object[]{this.getMode(stack)}));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return TextComponentUtil.build((Object[])new Object[]{EnumColor.AQUA, super.getName(stack)});
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility action) {
        if (action == MoreMachineItemAbilities.CONNECT_CHEMICALS) {
            return this.getMode(stack) == ConnectorMode.CONNECT_CHEMICALS;
        }
        if (action == MoreMachineItemAbilities.CONNECT_ENERGY) {
            return this.getMode(stack) == ConnectorMode.CONNECT_ENERGY;
        }
        if (action == MoreMachineItemAbilities.CONNECT_FLUIDS) {
            return this.getMode(stack) == ConnectorMode.CONNECT_FLUIDS;
        }
        if (action == MoreMachineItemAbilities.CONNECT_HEAT) {
            return this.getMode(stack) == ConnectorMode.CONNECT_HEAT;
        }
        if (action == MoreMachineItemAbilities.CONNECT_ITEMS) {
            return this.getMode(stack) == ConnectorMode.CONNECT_ITEMS;
        }
        return super.canPerformAction(stack, action);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        if (!world.isClientSide && player != null) {
            BlockPos pos = context.getClickedPos();
            Direction side = context.getClickedFace();
            ItemStack stack = context.getItemInHand();
            Block block = Objects.requireNonNull(WorldUtils.getBlockStateIfLoaded((BlockGetter)world, (BlockPos)pos)).getBlock();
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)pos);
            if (player.isShiftKeyDown()) {
                if (tile instanceof ITileConnect) {
                    stack.set(MoreMachineDataComponents.CONNECT_FROM, (Object)GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
                    player.displayClientMessage((Component)MoreMachineLang.CONNECTOR_FROM.translate(new Object[]{EnumColor.INDIGO, TextComponentUtil.translate((String)block.getDescriptionId())}), true);
                }
            } else {
                TileEntityWirelessTransmissionStation linkTile;
                GlobalPos globalPos = (GlobalPos)stack.get(MoreMachineDataComponents.CONNECT_FROM);
                if (globalPos != null && world.dimension() == globalPos.dimension() && (linkTile = (TileEntityWirelessTransmissionStation)WorldUtils.getTileEntity(TileEntityWirelessTransmissionStation.class, (BlockGetter)world, (BlockPos)globalPos.pos(), (boolean)true)) != null) {
                    switch (linkTile.connectOrCut(pos, side, ((ConnectorMode)((Object)this.getMode((ItemStack)stack))).transmissionType)) {
                        case CONNECT: {
                            player.displayClientMessage((Component)MoreMachineLang.CONNECTOR_TO.translate(new Object[]{EnumColor.INDIGO, TextComponentUtil.translate((String)block.getDescriptionId()), EnumColor.INDIGO, side}), true);
                            return InteractionResult.SUCCESS;
                        }
                        case DISCONNECT: {
                            player.displayClientMessage((Component)MoreMachineLang.CONNECTOR_DISCONNECT.translate(new Object[]{EnumColor.INDIGO, TextComponentUtil.translate((String)block.getDescriptionId()), EnumColor.INDIGO, side}), true);
                            return InteractionResult.SUCCESS;
                        }
                        case CONNECT_FAIL: {
                            player.displayClientMessage((Component)MoreMachineLang.CONNECTOR_FAIL.translate(new Object[]{EnumColor.DARK_RED, TextComponentUtil.translate((String)block.getDescriptionId()), EnumColor.DARK_RED, side}), true);
                            return InteractionResult.SUCCESS;
                        }
                    }
                    return InteractionResult.PASS;
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            ItemStack connector = player.getItemInHand(usedHand);
            if (!level.isClientSide) {
                connector.remove(MoreMachineDataComponents.CONNECT_FROM);
                player.displayClientMessage((Component)MoreMachineLang.CONNECTOR_CLEARED.translate(), true);
            }
            return InteractionResultHolder.sidedSuccess((Object)connector, (boolean)level.isClientSide);
        }
        return super.use(level, player, usedHand);
    }

    @NotNull
    public RadialData<ConnectorMode> getRadialData(ItemStack stack) {
        return (RadialData)LAZY_RADIAL_DATA.get();
    }

    public DataComponentType<ConnectorMode> getModeDataType() {
        return (DataComponentType)MoreMachineDataComponents.CONNECTOR_MODE.get();
    }

    public ConnectorMode getDefaultMode() {
        return ConnectorMode.CONNECT_ENERGY;
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        ConnectorMode newMode;
        ConnectorMode mode = (ConnectorMode)((Object)this.getMode(stack));
        if (mode != (newMode = (ConnectorMode)mode.adjust(shift))) {
            this.setMode(stack, player, (Object)newMode);
            displayChange.sendMessage(player, (Object)newMode, xva$0 -> MekanismLang.CONFIGURE_STATE.translate(new Object[]{xva$0}));
        }
    }

    @NothingNullByDefault
    public static enum ConnectorMode implements IIncrementalEnum<ConnectorMode>,
    IHasTextComponent.IHasEnumNameTextComponent,
    IRadialMode,
    StringRepresentable
    {
        CONNECT_ITEMS((ILangEntry)MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, null),
        CONNECT_FLUIDS((ILangEntry)MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, null),
        CONNECT_CHEMICALS((ILangEntry)MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.CHEMICAL, EnumColor.BRIGHT_GREEN, null),
        CONNECT_ENERGY((ILangEntry)MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, null),
        CONNECT_HEAT((ILangEntry)MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, null);

        public static final Codec<ConnectorMode> CODEC;
        public static final IntFunction<ConnectorMode> BY_ID;
        public static final StreamCodec<ByteBuf, ConnectorMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry langEntry;
        @Nullable
        private final TransmissionType transmissionType;
        private final EnumColor color;
        private final ResourceLocation icon;

        private ConnectorMode(ILangEntry langEntry, @Nullable TransmissionType transmissionType, EnumColor color, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.transmissionType = transmissionType;
            this.color = color;
            this.icon = transmissionType == null ? Objects.requireNonNull(icon, "Icon should only be null if there is a transmission type present.") : MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)(transmissionType.getTransmission() + ".png"));
        }

        public ConnectorMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        @NotNull
        public Component sliceName() {
            return this.transmissionType != null ? this.transmissionType.getLangEntry().translateColored(this.color) : this.getTextComponent();
        }

        @NotNull
        public ResourceLocation icon() {
            return this.icon;
        }

        public Component getTextComponent() {
            if (this.transmissionType == null) {
                return this.langEntry.translateColored(this.color);
            }
            return this.langEntry.translateColored(this.color, new Object[]{this.transmissionType});
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ConnectorMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ConnectorMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

