/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile;

import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineDataComponents;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWirelessChargingStation
extends TileEntityConfigurableMachine
implements IBoundingBlock {
    private MachineEnergyContainer<TileEntityWirelessChargingStation> energyContainer;
    private boolean chargeEquipment = false;
    private boolean chargeInventory = false;
    private boolean chargeCurios = false;
    EnergyInventorySlot chargeSlot;
    EnergyInventorySlot dischargeSlot;

    public TileEntityWirelessChargingStation(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.WIRELESS_CHARGING_STATION, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.chargeSlot, (Object)this.dischargeSlot, RelativeSide.FRONT, true);
        this.configComponent.setupIOConfig(TransmissionType.ENERGY, this.energyContainer, RelativeSide.FRONT);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.ENERGY}).setCanEject(type -> this.canFunction());
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.dischargeSlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityWirelessChargingStation)this).getLevel(), (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.dischargeSlot);
        this.chargeSlot = EnergyInventorySlot.drain(this.energyContainer, (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.chargeSlot);
        this.dischargeSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.chargeSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.chargeSlot.drainContainer();
        this.dischargeSlot.fillContainerOrConvert();
        if (!this.energyContainer.isEmpty() && this.isRedstoneActivated()) {
            Player player;
            Level level = this.getLevel();
            UUID uuid = this.getSecurity().getOwnerUUID();
            if (level != null && uuid != null && (player = level.getPlayerByUUID(uuid)) != null) {
                if (this.chargeEquipment) {
                    this.chargeSuit(player);
                }
                if (this.chargeInventory) {
                    this.chargeInventory(player);
                }
                if (this.chargeCurios) {
                    this.chargeCurios(player);
                }
            }
        }
        return sendUpdatePacket;
    }

    private void chargeSuit(Player player) {
        long toCharge = Math.min(MoreMachineConfig.general.wirelessChargingStationChargingRate.get(), this.energyContainer.getEnergy());
        if (toCharge == 0L) {
            return;
        }
        for (ItemStack stack : player.getArmorSlots()) {
            IEnergyContainer suitContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            if (suitContainer == null || (toCharge = this.charge((IEnergyContainer)this.energyContainer, stack, toCharge)) != 0L) continue;
            return;
        }
    }

    private void chargeInventory(Player player) {
        long toCharge = Math.min(MoreMachineConfig.general.wirelessChargingStationChargingRate.get(), this.energyContainer.getEnergy());
        if (toCharge == 0L) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        toCharge = this.charge((IEnergyContainer)this.energyContainer, mainHand, toCharge);
        if ((toCharge = this.charge((IEnergyContainer)this.energyContainer, offHand, toCharge)) > 0L) {
            for (ItemStack stack : player.getInventory().items) {
                if (stack == mainHand || stack == offHand || (toCharge = this.charge((IEnergyContainer)this.energyContainer, stack, toCharge)) != 0L) continue;
                return;
            }
        }
    }

    private void chargeCurios(Player player) {
        IItemHandler handler;
        long toCharge = Math.min(MoreMachineConfig.general.wirelessChargingStationChargingRate.get(), this.energyContainer.getEnergy());
        if (toCharge == 0L) {
            return;
        }
        if (Mekanism.hooks.curios.isLoaded() && (handler = CuriosIntegration.getCuriosInventory((LivingEntity)player)) != null) {
            int slots = handler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                toCharge = this.charge((IEnergyContainer)this.energyContainer, handler.getStackInSlot(slot), toCharge);
                if (toCharge != 0L) continue;
                return;
            }
        }
    }

    private long charge(IEnergyContainer energyContainer, ItemStack stack, long amount) {
        long remaining;
        IStrictEnergyHandler handler;
        if (!stack.isEmpty() && amount > 0L && (handler = EnergyCompatUtils.getStrictEnergyHandler((ItemStack)stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)) < amount) {
            long toExtract = amount - remaining;
            long extracted = energyContainer.extract(toExtract, Action.EXECUTE, AutomationType.MANUAL);
            long inserted = handler.insertEnergy(extracted, Action.EXECUTE);
            return inserted + remaining;
        }
        return amount;
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        data.putBoolean("charge_equipment", this.getChargeEquipment());
        data.putBoolean("charge_inventory", this.getChargeInventory());
        data.putBoolean("charge_curios", this.getChargeCurios());
    }

    public void readSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"charge_equipment", value -> {
            this.chargeEquipment = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"charge_inventory", value -> {
            this.chargeInventory = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"charge_curios", value -> {
            this.chargeCurios = value;
        });
    }

    public void toggleChargeEquipment() {
        this.chargeEquipment = !this.chargeEquipment;
        this.markForSave();
    }

    public void toggleChargeInventory() {
        this.chargeInventory = !this.chargeInventory;
        this.markForSave();
    }

    public void toggleChargeCurios() {
        this.chargeCurios = !this.chargeCurios;
        this.markForSave();
    }

    public boolean getChargeEquipment() {
        return this.chargeEquipment;
    }

    public boolean getChargeInventory() {
        return this.chargeInventory;
    }

    public boolean getChargeCurios() {
        return this.chargeCurios;
    }

    public MachineEnergyContainer<TileEntityWirelessChargingStation> getEnergyContainer() {
        return this.energyContainer;
    }

    public long getOutput() {
        return Math.min(MekanismConfig.gear.mekaSuitInventoryChargeRate.get(), this.energyContainer.getEnergy());
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MoreMachineDataComponents.CHARGE_EQUIPMENT, (Object)this.getChargeEquipment());
        builder.set(MoreMachineDataComponents.CHARGE_INVENTORY, (Object)this.getChargeInventory());
        builder.set(MoreMachineDataComponents.CHARGE_CURIOS, (Object)this.getChargeCurios());
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.chargeEquipment = (Boolean)input.getOrDefault(MoreMachineDataComponents.CHARGE_EQUIPMENT, (Object)this.chargeEquipment);
        this.chargeInventory = (Boolean)input.getOrDefault(MoreMachineDataComponents.CHARGE_INVENTORY, (Object)this.chargeInventory);
        this.chargeCurios = (Boolean)input.getOrDefault(MoreMachineDataComponents.CHARGE_CURIOS, (Object)this.chargeCurios);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::getChargeEquipment, value -> {
            this.chargeEquipment = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::getChargeInventory, value -> {
            this.chargeInventory = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::getChargeCurios, value -> {
            this.chargeCurios = value;
        }));
    }
}

