/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.api.recipes.RecyclerRecipe;
import com.jerry.mekmm.api.recipes.cache.MoreMachineOneInputCachedRecipe;
import com.jerry.mekmm.api.recipes.outputs.MoreMachineOutputHelper;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.inventory.slot.MoreMachineFactoryInputInventorySlot;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tier.FactoryTier;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityRecyclingFactory
extends TileEntityMoreMachineFactory<RecyclerRecipe>
implements ISingleRecipeLookupHandler.ItemRecipeLookupHandler<RecyclerRecipe> {
    private static final TriPredicate<RecyclerRecipe, ItemStack, ItemStack> OUTPUT_CHECK = (recipe, input, output) -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput((ItemStack)input).getMaxChanceOutput(), (ItemStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);
    protected IInputHandler<@NotNull ItemStack>[] inputHandlers;
    protected IOutputHandler<RecyclerRecipe.ChanceOutput>[] outputHandlers;

    public TileEntityRecyclingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        int baseX;
        this.inputHandlers = new IInputHandler[this.tier.processes];
        this.outputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new TileEntityMoreMachineFactory.ProcessInfo[this.tier.processes];
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < this.tier.processes; ++i) {
            int xPos = baseX + i * baseXMult;
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            OutputInventorySlot outputSlot = OutputInventorySlot.at((IContentsListener)updateSortingAndUnpause, (int)xPos, (int)57);
            MoreMachineFactoryInputInventorySlot inputSlot = MoreMachineFactoryInputInventorySlot.create(this, i, (IInventorySlot)outputSlot, (IContentsListener)lookupMonitor, xPos, 13);
            int index = i;
            ((MoreMachineFactoryInputInventorySlot)builder.addSlot((IInventorySlot)inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            ((OutputInventorySlot)builder.addSlot((IInventorySlot)outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, index)));
            this.inputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.outputHandlers[i] = MoreMachineOutputHelper.getOutputHandler((IInventorySlot)outputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
            this.processInfoSlots[i] = new TileEntityMoreMachineFactory.ProcessInfo(i, inputSlot, (IInventorySlot)outputSlot, null);
        }
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<RecyclerRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && ((RecyclerRecipe)cached.getRecipe()).getInput().testType(stack);
    }

    @Override
    @Nullable
    protected RecyclerRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot chanceOutputSlot, @Nullable IInventorySlot outputSlot) {
        return (RecyclerRecipe)((InputRecipeCache.SingleItem)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)chanceOutputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    protected int getNeededInput(RecyclerRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount(inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipe(stack);
    }

    @NotNull
    public IMekanismRecipeTypeProvider<SingleRecipeInput, RecyclerRecipe, InputRecipeCache.SingleItem<RecyclerRecipe>> getRecipeType() {
        return MoreMachineRecipeType.RECYCLING;
    }

    public IRecipeViewerRecipeType<RecyclerRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.RECYCLER;
    }

    @Nullable
    public RecyclerRecipe getRecipe(int cacheIndex) {
        return (RecyclerRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<RecyclerRecipe> createNewCachedRecipe(@NotNull RecyclerRecipe recipe, int cacheIndex) {
        return MoreMachineOneInputCachedRecipe.recycler(recipe, this.recheckAllRecipeErrors[cacheIndex], this.inputHandlers[cacheIndex], this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityRecyclingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityRecyclingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @NotNull
    public MachineUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new MachineUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

