/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.api.recipes.StamperRecipe;
import com.jerry.mekmm.api.recipes.cache.StamperCachedRecipe;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.tile.factory.TileEntityItemToItemMMFactory;
import com.jerry.mekmm.common.upgrade.StamperUpgradeData;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityStampingFactory
extends TileEntityItemToItemMMFactory<StamperRecipe>
implements IDoubleRecipeLookupHandler.DoubleItemRecipeLookupHandler<StamperRecipe> {
    private static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ItemStack, StamperRecipe, ItemStack> OUTPUT_CHECK = (recipe, input, extra, output) -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput((ItemStack)input, (ItemStack)extra), (ItemStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getSecondaryInput"}, docPlaceholder="secondary input slot")
    InputInventorySlot extraSlot;

    public TileEntityStampingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.extraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.extraSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.extraSlot = InputInventorySlot.at(arg_0 -> ((TileEntityStampingFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener), (int)7, (int)57);
        builder.addSlot((IInventorySlot)this.extraSlot);
        this.extraSlot.setSlotType(ContainerSlotType.EXTRA);
    }

    @Nullable
    protected InputInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, this.extraSlot.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(StamperRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<StamperRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            StamperRecipe cachedRecipe = (StamperRecipe)cached.getRecipe();
            return cachedRecipe.getInput().testType(stack) && (this.extraSlot.isEmpty() || cachedRecipe.getMold().testType(this.extraSlot.getStack()));
        }
        return false;
    }

    @Override
    protected StamperRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        return (StamperRecipe)((InputRecipeCache.DoubleItem)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)this.extraSlot.getStack(), (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @NotNull
    public IMekanismRecipeTypeProvider<RecipeInput, StamperRecipe, InputRecipeCache.DoubleItem<StamperRecipe>> getRecipeType() {
        return MoreMachineRecipeType.STAMPING;
    }

    public IRecipeViewerRecipeType<StamperRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.STAMPING;
    }

    @Nullable
    public StamperRecipe getRecipe(int cacheIndex) {
        return (StamperRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.extraInputHandler);
    }

    @NotNull
    public CachedRecipe<StamperRecipe> createNewCachedRecipe(@NotNull StamperRecipe recipe, int cacheIndex) {
        return StamperCachedRecipe.createCache(recipe, this.recheckAllRecipeErrors[cacheIndex], (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.extraInputHandler, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityStampingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityStampingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof StamperUpgradeData) {
            StamperUpgradeData data = (StamperUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.extraSlot.deserializeNBT(provider, data.extraSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public StamperUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new StamperUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.extraSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

