/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.loot.table;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.util.EnumUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBlockLootTables
extends BlockLootSubProvider {
    private static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();
    private final Set<Block> toSkip = new ReferenceArraySet();

    protected BaseBlockLootTables() {
        super(Collections.emptySet(), FeatureFlags.f_244377_);
    }

    protected void m_247577_(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.m_247577_(block, table);
        this.knownBlocks.add(block);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected void skip(IBlockProvider ... blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            this.toSkip.add(blockProvider.getBlock());
        }
    }

    protected boolean skipBlock(Block block) {
        return this.knownBlocks.contains(block) || this.toSkip.contains(block);
    }

    protected LootTable.Builder createOreDrop(Block block, ItemLike item) {
        return BaseBlockLootTables.m_247502_(block, (LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item.m_5456_()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected LootTable.Builder droppingWithFortuneOrRandomly(Block block, ItemLike item, UniformGenerator range) {
        return BaseBlockLootTables.m_247502_(block, (LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item.m_5456_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)range)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected void dropSelf(List<IBlockProvider> blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            Block block = blockProvider.getBlock();
            if (this.skipBlock(block)) continue;
            this.m_245724_(block);
        }
    }

    protected void add(Function<Block, LootTable.Builder> factory, Collection<? extends IBlockProvider> blockProviders) {
        for (IBlockProvider iBlockProvider : blockProviders) {
            this.m_246481_(iBlockProvider.getBlock(), factory);
        }
    }

    protected void add(Function<Block, LootTable.Builder> factory, IBlockProvider ... blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            this.m_246481_(blockProvider.getBlock(), factory);
        }
    }

    protected void add(Function<Block, LootTable.Builder> factory, OreBlockType ... oreTypes) {
        for (OreBlockType oreType : oreTypes) {
            this.m_246481_((Block)oreType.stoneBlock(), factory);
            this.m_246481_((Block)oreType.deepslateBlock(), factory);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void dropSelfWithContents(List<IBlockProvider> blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            Attributes.AttributeInventory attributeInventory;
            SubstanceType[] remapEntries;
            IFrequencyHandler frequencyHandler;
            Block block = blockProvider.getBlock();
            if (this.skipBlock(block)) continue;
            TrackingNbtBuilder nbtBuilder = new TrackingNbtBuilder((NbtProvider)ContextNbtProvider.f_165562_);
            boolean hasContents = false;
            LootPoolSingletonContainer.Builder itemLootPool = LootItem.m_79579_((ItemLike)block);
            DelayedLootItemBuilder delayedPool = new DelayedLootItemBuilder();
            BlockEntity tile = null;
            if (block instanceof IHasTileEntity) {
                IHasTileEntity hasTileEntity = (IHasTileEntity)block;
                tile = hasTileEntity.createDummyBlockEntity();
            }
            if (tile instanceof IFrequencyHandler && (frequencyHandler = (IFrequencyHandler)tile).getFrequencyComponent().hasCustomFrequencies()) {
                nbtBuilder.m_80279_("componentFrequency", "mekData.componentFrequency");
            }
            if (Attribute.has((Block)block, Attributes.AttributeSecurity.class)) {
                nbtBuilder.m_80279_("componentSecurity.owner", "mekData.owner");
                nbtBuilder.m_80279_("componentSecurity.securityMode", "mekData.securityMode");
            }
            if (Attribute.has((Block)block, AttributeUpgradeSupport.class)) {
                nbtBuilder.m_80279_("componentUpgrade", "mekData.componentUpgrade");
            }
            if (tile instanceof ISideConfiguration) {
                nbtBuilder.m_80279_("componentConfig", "mekData.componentConfig");
                nbtBuilder.m_80279_("componentEjector", "mekData.componentEjector");
            }
            if (tile instanceof ISustainedData) {
                ISustainedData sustainedData = (ISustainedData)tile;
                remapEntries = sustainedData.getTileDataRemap().entrySet();
                for (Map.Entry entry : remapEntries) {
                    nbtBuilder.m_80279_((String)entry.getKey(), "mekData." + (String)entry.getValue());
                }
            }
            if (Attribute.has((Block)block, Attributes.AttributeRedstone.class)) {
                nbtBuilder.m_80279_("controlType", "mekData.controlType");
            }
            if (tile instanceof TileEntityMekanism) {
                void var13_16;
                TileEntityMekanism tileEntity = (TileEntityMekanism)tile;
                if (tileEntity.isNameable()) {
                    itemLootPool.m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
                }
                remapEntries = EnumUtils.SUBSTANCES;
                int n = remapEntries.length;
                boolean bl = false;
                while (var13_16 < n) {
                    SubstanceType type = remapEntries[var13_16];
                    if (tileEntity.handles(type) && !type.getContainers(tileEntity).isEmpty()) {
                        nbtBuilder.m_80279_(type.getContainerTag(), "mekData." + type.getContainerTag());
                        if (type != SubstanceType.ENERGY && type != SubstanceType.HEAT) {
                            hasContents = true;
                        }
                    }
                    ++var13_16;
                }
            }
            if ((attributeInventory = (Attributes.AttributeInventory)Attribute.get((Block)block, Attributes.AttributeInventory.class)) != null) {
                TileEntityMekanism tileMek;
                IItemHandler handler;
                if (attributeInventory.hasCustomLoot()) {
                    hasContents = attributeInventory.applyLoot((ConditionUserBuilder)delayedPool, (CopyNbtFunction.Builder)nbtBuilder);
                } else if (!(tile instanceof IItemHandler && (handler = (IItemHandler)tile).getSlots() <= 0 || tile instanceof TileEntityMekanism && !(tileMek = (TileEntityMekanism)tile).persistInventory())) {
                    nbtBuilder.m_80279_("Items", "mekData.Items");
                    hasContents = true;
                }
            }
            if (block instanceof BlockCardboardBox) {
                nbtBuilder.m_80279_("data", "mekData.data");
            }
            if (nbtBuilder.hasData()) {
                itemLootPool.m_79078_((LootItemFunction.Builder)nbtBuilder);
            }
            for (LootItemFunction.Builder function : delayedPool.functions) {
                itemLootPool.m_79078_(function);
            }
            for (LootItemCondition.Builder condition : delayedPool.conditions) {
                itemLootPool.m_79080_(condition);
            }
            this.m_247577_(block, LootTable.m_79147_().m_79161_((LootPool.Builder)BaseBlockLootTables.applyExplosionCondition(hasContents, LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)itemLootPool))));
        }
    }

    private static <T extends ConditionUserBuilder<T>> T applyExplosionCondition(boolean explosionResistant, ConditionUserBuilder<T> condition) {
        return (T)(explosionResistant ? condition.m_79073_() : condition.m_79080_(ExplosionCondition.m_81661_()));
    }

    @NotNull
    protected LootTable.Builder m_247233_(@NotNull Block slab) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)slab, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)slab).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)slab).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))))));
    }

    public void m_246125_(@NotNull Block block, @NotNull ItemLike drop) {
        this.m_247577_(block, this.m_247033_(drop));
    }

    @NotNull
    public LootTable.Builder m_247033_(@NotNull ItemLike item) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_(item, (ConditionUserBuilder)LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item))));
    }

    @NotNull
    protected LootTable.Builder m_245142_(@NotNull Block block, @NotNull ItemLike item, @NotNull NumberProvider range) {
        return BaseBlockLootTables.m_247502_(block, (LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)range))));
    }

    @NotNull
    protected static LootTable.Builder m_247502_(@NotNull Block block, @NotNull LootPoolEntryContainer.Builder<?> builder) {
        return BaseBlockLootTables.m_246900_(block, HAS_SILK_TOUCH, builder);
    }

    @NotNull
    protected static LootTable.Builder m_246900_(@NotNull Block block, @NotNull LootItemCondition.Builder conditionBuilder, @NotNull LootPoolEntryContainer.Builder<?> entry) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(conditionBuilder)).m_7170_(entry)));
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNotNullByDefault
    public static class TrackingNbtBuilder
    extends CopyNbtFunction.Builder {
        private boolean hasData = false;

        public TrackingNbtBuilder(NbtProvider pNbtSource) {
            super(pNbtSource);
        }

        public boolean hasData() {
            return this.hasData;
        }

        public CopyNbtFunction.Builder m_80282_(String pSourcePath, String pTargetPath, CopyNbtFunction.MergeStrategy pCopyAction) {
            this.hasData = true;
            return super.m_80282_(pSourcePath, pTargetPath, pCopyAction);
        }
    }

    @NothingNullByDefault
    public static class DelayedLootItemBuilder
    implements ConditionUserBuilder<DelayedLootItemBuilder>,
    FunctionUserBuilder<DelayedLootItemBuilder> {
        private final List<LootItemFunction.Builder> functions = new ArrayList<LootItemFunction.Builder>();
        private final List<LootItemCondition.Builder> conditions = new ArrayList<LootItemCondition.Builder>();

        public DelayedLootItemBuilder apply(LootItemFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder);
            return this;
        }

        public DelayedLootItemBuilder when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder);
            return this;
        }

        public DelayedLootItemBuilder unwrap() {
            return this;
        }
    }
}

