/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.impl;

import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import com.jerry.datagen.common.recipe.builder.MoreMachineDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.impl.MoreMachineRecipeProvider;
import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekaf.common.block.prefab.BlockAdvancedFactoryMachine;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.item.ItemBlockAdvancedFactory;
import com.jerry.mekaf.common.registries.AdvancedFactoryBlocks;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import java.util.function.Consumer;
import mekanism.api.providers.IItemProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

class AdvancedFactoryRecipeProvider
implements ISubRecipeProvider {
    AdvancedFactoryRecipeProvider() {
    }

    @Override
    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "factory/";
        String basicPath = basePath + "basic/";
        String advancedPath = basePath + "advanced/";
        String elitePath = basePath + "elite/";
        String ultimatePath = basePath + "ultimate/";
        TagKey osmiumIngot = (TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.OSMIUM);
        for (AdvancedFactoryType type : MoreMachineEnumUtils.ADVANCED_FACTORY_TYPES) {
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> basicFactory = AdvancedFactoryBlocks.getAdvancedFactory(FactoryTier.BASIC, type);
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> advancedFactory = AdvancedFactoryBlocks.getAdvancedFactory(FactoryTier.ADVANCED, type);
            BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> eliteFactory = AdvancedFactoryBlocks.getAdvancedFactory(FactoryTier.ELITE, type);
            this.addFactoryRecipe(consumer, basicPath, basicFactory, (IItemProvider)type.getBaseBlock(), (TagKey<Item>)Tags.Items.INGOTS_IRON, (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC, (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC);
            this.addFactoryRecipe(consumer, advancedPath, advancedFactory, (IItemProvider)basicFactory, (TagKey<Item>)osmiumIngot, (TagKey<Item>)MekanismTags.Items.ALLOYS_INFUSED, (TagKey<Item>)MekanismTags.Items.CIRCUITS_ADVANCED);
            this.addFactoryRecipe(consumer, elitePath, eliteFactory, (IItemProvider)advancedFactory, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)MekanismTags.Items.ALLOYS_REINFORCED, (TagKey<Item>)MekanismTags.Items.CIRCUITS_ELITE);
            this.addFactoryRecipe(consumer, ultimatePath, AdvancedFactoryBlocks.getAdvancedFactory(FactoryTier.ULTIMATE, type), (IItemProvider)eliteFactory, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC, (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE);
        }
    }

    private void addFactoryRecipe(Consumer<FinishedRecipe> consumer, String basePath, BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ?> factory, IItemProvider toUpgrade, TagKey<Item> ingotTag, TagKey<Item> alloyTag, TagKey<Item> circuitTag) {
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(factory).pattern(MoreMachineRecipeProvider.TIER_PATTERN).key('P', (ItemLike)toUpgrade).key('C', circuitTag).key('I', ingotTag).key('A', alloyTag).build(consumer, Mekmm.rl(basePath + ((AttributeAdvancedFactoryType)Attribute.get(factory, AttributeAdvancedFactoryType.class)).getAdvancedFactoryType().getRegistryNameComponent()));
    }
}

