/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntityItemToFluidFactory;
import com.jerry.mekaf.common.upgrade.ItemToFluidUpgradeData;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackToFluidRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.impl.NutritionalLiquifierIRecipe;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLiquifyingFactory
extends TileEntityItemToFluidFactory<ItemStackToFluidRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);

    public TileEntityLiquifyingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.FLUID});
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackToFluidRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && this.isValidInputItem(stack);
    }

    @Override
    @Nullable
    protected ItemStackToFluidRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IExtendedFluidTank outputTanks) {
        return null;
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        FoodProperties food = stack.getFoodProperties(null);
        return food != null && food.m_38744_() > 0;
    }

    @Override
    protected int getNeededInput(ItemStackToFluidRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount((Object)inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ItemStackToFluidRecipe, ?> getRecipeType() {
        return null;
    }

    @Nullable
    public ItemStackToFluidRecipe getRecipe(int cacheIndex) {
        ItemStack stack = (ItemStack)this.itemInputHandlers[cacheIndex].getInput();
        if (stack.m_41619_() || !stack.m_41720_().m_41472_()) {
            return null;
        }
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null || food.m_38744_() == 0) {
            return null;
        }
        return new NutritionalLiquifierIRecipe(stack.m_41720_(), IngredientCreatorAccess.item().from(stack, 1), MekanismFluids.NUTRITIONAL_PASTE.getFluidStack(food.m_38744_() * 50));
    }

    @NotNull
    public CachedRecipe<ItemStackToFluidRecipe> createNewCachedRecipe(@NotNull ItemStackToFluidRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.itemToFluid((ItemStackToFluidRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.itemInputHandlers[cacheIndex], (IOutputHandler)this.fluidOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityLiquifyingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Nullable
    public ItemToFluidUpgradeData getUpgradeData() {
        return new ItemToFluidUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputItemSlots, this.outputFluidTanks, this.isSorting(), this.getComponents());
    }
}

