/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntityItemToGasFactory;
import com.jerry.mekaf.common.upgrade.ItemToGasUpgradeData;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityOxidizingFactory
extends TileEntityItemToGasFactory<ItemStackToGasRecipe>
implements ISingleRecipeLookupHandler.ItemRecipeLookupHandler<ItemStackToGasRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);

    public TileEntityOxidizingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.GAS});
    }

    @Override
    @Contract(value="null, _ -> false")
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackToGasRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && ((ItemStackToGasRecipe)cached.getRecipe()).getInput().testType((Object)stack);
    }

    @Override
    @Nullable
    protected ItemStackToGasRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IGasTank outputTanks) {
        GasStack output = (GasStack)outputTanks.getStack();
        return (ItemStackToGasRecipe)((InputRecipeCache.SingleItem)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)fallbackInput, recipe -> output.isTypeEqual(recipe.getOutput(fallbackInput)));
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    protected int getNeededInput(ItemStackToGasRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount((Object)inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> getRecipeType() {
        return MekanismRecipeType.OXIDIZING;
    }

    @Nullable
    public ItemStackToGasRecipe getRecipe(int cacheIndex) {
        return (ItemStackToGasRecipe)this.findFirstRecipe(this.itemInputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<ItemStackToGasRecipe> createNewCachedRecipe(@NotNull ItemStackToGasRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.itemToChemical((ItemStackToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.itemInputHandlers[cacheIndex], (IOutputHandler)this.gasOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityOxidizingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new ItemToGasUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputItemSlots, this.outputGasTanks, this.isSorting(), this.getComponents());
    }
}

