/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.base;

import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.GasToGasUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityGasToGasFactory<RECIPE extends MekanismRecipe>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    private static final long MAX_CHEMICAL = 10000L;
    protected GasToGasProcessInfo[] processInfoSlots;
    IGasTank[] inputTank;
    IGasTank[] outputTank;
    public final List<IGasTank> inputGasTanks = new ArrayList<IGasTank>();
    public final List<IGasTank> outputGasTanks = new ArrayList<IGasTank>();

    protected TileEntityGasToGasFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        ConfigInfo itemConfig;
        for (GasToGasProcessInfo info : this.processInfoSlots) {
            this.inputGasTanks.add(info.inputTank());
            this.outputGasTanks.add(info.outputTank());
        }
        this.configComponent.addSupported(TransmissionType.GAS);
        ConfigInfo gasConfig = this.configComponent.getConfig(TransmissionType.GAS);
        if (gasConfig != null) {
            gasConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(false, true, this.outputGasTanks));
        }
        if ((itemConfig = this.configComponent.getConfig(TransmissionType.ITEM)) != null) {
            itemConfig.addSlotInfo(DataType.ENERGY, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.energySlot}));
            itemConfig.fill(DataType.ENERGY);
        }
    }

    @Override
    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputTank = new IGasTank[this.tier.processes];
        this.outputTank = new IGasTank[this.tier.processes];
        this.gasInputHandlers = new IInputHandler[this.tier.processes];
        this.gasOutputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new GasToGasProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            int index = i;
            this.outputTank[i] = (IGasTank)ChemicalTankBuilder.GAS.output(10000L * (long)this.tier.processes, listener);
            this.inputTank[i] = (IGasTank)ChemicalTankBuilder.GAS.create(10000L * (long)this.tier.processes, ChemicalTankHelper.radioactiveInputTankPredicate(() -> this.outputTank[index]), (stack, type) -> this.isValidInputChemical(stack.getStack(1L)), stack -> this.isChemicalValidForTank(stack.getStack(1L)) && this.inputProducesOutput(index, stack.getStack(1L), this.outputTank[index], false), ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.recipeCacheLookupMonitors[index]);
            builder.addTank((IChemicalTank)this.inputTank[i]);
            builder.addTank((IChemicalTank)this.outputTank[i]);
            this.gasInputHandlers[i] = InputHelper.getInputHandler((IChemicalTank)this.inputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.gasOutputHandlers[i] = OutputHelper.getOutputHandler((IChemicalTank)this.outputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
            this.processInfoSlots[i] = new GasToGasProcessInfo(i, this.inputTank[i], this.outputTank[i]);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull GasStack fallbackInput, @NotNull IGasTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull GasStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull GasStack fallbackInput, @NotNull IGasTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull GasStack var2, @NotNull IGasTank var3);

    public abstract boolean isChemicalValidForTank(@NotNull GasStack var1);

    public abstract boolean isValidInputChemical(@NotNull GasStack var1);

    protected abstract int getNeededInput(RECIPE var1, GasStack var2);

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof GasToGasUpgradeData) {
            int i;
            GasToGasUpgradeData data = (GasToGasUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputTanks.size(); ++i) {
                this.inputGasTanks.get(i).deserializeNBT(data.inputTanks.get(i).serializeNBT());
            }
            for (i = 0; i < data.outputTanks.size(); ++i) {
                this.outputGasTanks.get(i).setStack((ChemicalStack)((GasStack)data.outputTanks.get(i).getStack()));
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
    }

    public record GasToGasProcessInfo(int process, @NotNull IGasTank inputTank, @NotNull IGasTank outputTank) {
    }

    public static class GasToGasRecipeProcessInfo {
        private final List<GasToGasProcessInfo> processes = new ArrayList<GasToGasProcessInfo>();
        @Nullable
        private IntSupplier lazyMinPerSlot;
        private int minPerSlot = 1;
        private int totalCount;

        public int getMinPerSlot() {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = this.lazyMinPerSlot.getAsInt();
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

