/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.base;

import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.MergedToItemUpgradeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityMergedToItemFactory<RECIPE extends MekanismRecipe>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    protected MergedToItemProcessInfo[] processInfoSlots;
    protected OutputInventorySlot[] outputSlot;
    protected MergedChemicalTank[] inputTank;
    public final List<MergedChemicalTank> inputChemicalTanks;
    public final List<IInventorySlot> outputItemSlots = new ArrayList<IInventorySlot>();
    public final List<IGasTank> inputGasTanks;
    public final List<IInfusionTank> inputInfusionTanks;
    public final List<IPigmentTank> inputPigmentTanks;
    public final List<ISlurryTank> inputSlurryTanks;

    protected TileEntityMergedToItemFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        ConfigInfo slurryConfig;
        ConfigInfo pigmentConfig;
        ConfigInfo infusionConfig;
        this.inputChemicalTanks = new ArrayList<MergedChemicalTank>();
        this.processInfoSlots = new MergedToItemProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.processInfoSlots[i] = new MergedToItemProcessInfo(i, this.inputTank[i], (IInventorySlot)this.outputSlot[i]);
        }
        for (MergedToItemProcessInfo info : this.processInfoSlots) {
            this.inputChemicalTanks.add(info.inputTank);
            this.outputItemSlots.add(info.outputSlot);
        }
        this.addSupported(TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY);
        this.inputGasTanks = new ArrayList<IGasTank>();
        this.inputInfusionTanks = new ArrayList<IInfusionTank>();
        this.inputPigmentTanks = new ArrayList<IPigmentTank>();
        this.inputSlurryTanks = new ArrayList<ISlurryTank>();
        for (MergedChemicalTank tank : this.inputChemicalTanks) {
            this.inputGasTanks.add(tank.getGasTank());
            this.inputInfusionTanks.add(tank.getInfusionTank());
            this.inputPigmentTanks.add(tank.getPigmentTank());
            this.inputSlurryTanks.add(tank.getSlurryTank());
        }
        ConfigInfo gasConfig = this.configComponent.getConfig(TransmissionType.GAS);
        if (gasConfig != null) {
            gasConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, false, this.inputGasTanks));
            gasConfig.setDataType(DataType.INPUT, new RelativeSide[]{RelativeSide.RIGHT});
            gasConfig.fill(DataType.INPUT);
            gasConfig.setCanEject(false);
        }
        if ((infusionConfig = this.configComponent.getConfig(TransmissionType.INFUSION)) != null) {
            infusionConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.InfusionSlotInfo(true, false, this.inputInfusionTanks));
            infusionConfig.fill(DataType.INPUT);
            infusionConfig.setCanEject(false);
        }
        if ((pigmentConfig = this.configComponent.getConfig(TransmissionType.PIGMENT)) != null) {
            pigmentConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.PigmentSlotInfo(true, false, this.inputPigmentTanks));
            pigmentConfig.setDataType(DataType.INPUT, new RelativeSide[]{RelativeSide.RIGHT});
            pigmentConfig.fill(DataType.INPUT);
            pigmentConfig.setCanEject(false);
        }
        if ((slurryConfig = this.configComponent.getConfig(TransmissionType.SLURRY)) != null) {
            slurryConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.SlurrySlotInfo(true, false, this.inputSlurryTanks));
            slurryConfig.setDataType(DataType.INPUT, new RelativeSide[]{RelativeSide.RIGHT});
            slurryConfig.fill(DataType.INPUT);
            slurryConfig.setCanEject(false);
        }
        this.configComponent.setupItemIOConfig(Collections.emptyList(), this.outputItemSlots, (IInventorySlot)this.energySlot, false);
    }

    @Override
    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.inputTank[i].getGasTank());
        }
    }

    @Override
    protected void addInfusionTanks(ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.inputTank[i].getInfusionTank());
        }
    }

    @Override
    protected void addPigmentTanks(ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.inputTank[i].getPigmentTank());
        }
    }

    @Override
    protected void addSlurryTanks(ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.inputTank[i].getSlurryTank());
        }
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.outputSlot = new OutputInventorySlot[this.tier.processes];
        this.itemOutputHandlers = new IOutputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.outputSlot[i] = OutputInventorySlot.at((IContentsListener)this.recipeCacheLookupMonitors[i], (int)this.getXPos(i), (int)70);
            int index = i;
            ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.outputSlot[i])).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, index)));
            this.itemOutputHandlers[i] = OutputHelper.getOutputHandler((IInventorySlot)this.outputSlot[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        }
    }

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof MergedToItemUpgradeData) {
            int i;
            MergedToItemUpgradeData data = (MergedToItemUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputItemSlots.get(i).deserializeNBT((Tag)((CompoundTag)data.outputSlots.get(i).serializeNBT()));
            }
            for (i = 0; i < data.inputTanks.size(); ++i) {
                this.inputChemicalTanks.get(i).getGasTank().setStack((ChemicalStack)((GasStack)data.inputTanks.get(i).getGasTank().getStack()));
                this.inputChemicalTanks.get(i).getInfusionTank().setStack((ChemicalStack)((InfusionStack)data.inputTanks.get(i).getInfusionTank().getStack()));
                this.inputChemicalTanks.get(i).getPigmentTank().setStack((ChemicalStack)((PigmentStack)data.inputTanks.get(i).getPigmentTank().getStack()));
                this.inputChemicalTanks.get(i).getSlurryTank().setStack((ChemicalStack)((SlurryStack)data.inputTanks.get(i).getSlurryTank().getStack()));
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
    }

    public record MergedToItemProcessInfo(int process, MergedChemicalTank inputTank, @NotNull IInventorySlot outputSlot) {
    }
}

