/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.base;

import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.SlurryToSlurryUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntitySlurryToSlurryFactory<RECIPE extends MekanismRecipe>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    private static final long MAX_CHEMICAL = 10000L;
    protected SlurryToSlurryProcessInfo[] processInfoSlots;
    ISlurryTank[] inputTank;
    ISlurryTank[] outputTank;
    public final List<ISlurryTank> inputSlurryTanks = new ArrayList<ISlurryTank>();
    public final List<ISlurryTank> outputSlurryTanks = new ArrayList<ISlurryTank>();

    protected TileEntitySlurryToSlurryFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        ConfigInfo itemConfig;
        for (SlurryToSlurryProcessInfo info : this.processInfoSlots) {
            this.inputSlurryTanks.add(info.inputTank());
            this.outputSlurryTanks.add(info.outputTank());
        }
        this.configComponent.addSupported(TransmissionType.SLURRY);
        ConfigInfo slurryConfig = this.configComponent.getConfig(TransmissionType.SLURRY);
        if (slurryConfig != null) {
            slurryConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.SlurrySlotInfo(false, true, this.outputSlurryTanks));
            slurryConfig.fill(DataType.INPUT);
            slurryConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            slurryConfig.setEjecting(true);
        }
        if ((itemConfig = this.configComponent.getConfig(TransmissionType.ITEM)) != null) {
            itemConfig.addSlotInfo(DataType.ENERGY, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.energySlot}));
        }
    }

    @Override
    protected void addSlurryTanks(ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputTank = new ISlurryTank[this.tier.processes];
        this.outputTank = new ISlurryTank[this.tier.processes];
        this.slurryInputHandlers = new IInputHandler[this.tier.processes];
        this.slurryOutputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new SlurryToSlurryProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            int index = i;
            this.outputTank[i] = (ISlurryTank)ChemicalTankBuilder.SLURRY.output(10000L * (long)this.tier.processes, listener);
            this.inputTank[i] = (ISlurryTank)ChemicalTankBuilder.SLURRY.input(10000L * (long)this.tier.processes, stack -> this.isValidInputChemical(stack.getStack(1L)), stack -> this.isChemicalValidForTank(stack.getStack(1L)) && this.inputProducesOutput(index, stack.getStack(1L), this.outputTank[index], false), (IContentsListener)this.recipeCacheLookupMonitors[index]);
            builder.addTank((IChemicalTank)this.inputTank[i]);
            builder.addTank((IChemicalTank)this.outputTank[i]);
            this.slurryInputHandlers[i] = InputHelper.getInputHandler((IChemicalTank)this.inputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.slurryOutputHandlers[i] = OutputHelper.getOutputHandler((IChemicalTank)this.outputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
            this.processInfoSlots[i] = new SlurryToSlurryProcessInfo(i, this.inputTank[i], this.outputTank[i]);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull SlurryStack fallbackInput, @NotNull ISlurryTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull SlurryStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull SlurryStack fallbackInput, @NotNull ISlurryTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull SlurryStack var2, @NotNull ISlurryTank var3);

    public abstract boolean isChemicalValidForTank(@NotNull SlurryStack var1);

    public abstract boolean isValidInputChemical(@NotNull SlurryStack var1);

    protected abstract int getNeededInput(RECIPE var1, SlurryStack var2);

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof SlurryToSlurryUpgradeData) {
            int i;
            SlurryToSlurryUpgradeData data = (SlurryToSlurryUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputTanks.size(); ++i) {
                this.inputSlurryTanks.get(i).deserializeNBT(data.inputTanks.get(i).serializeNBT());
            }
            for (i = 0; i < data.outputTanks.size(); ++i) {
                this.outputSlurryTanks.get(i).setStack((ChemicalStack)((SlurryStack)data.outputTanks.get(i).getStack()));
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    public record SlurryToSlurryProcessInfo(int process, @NotNull ISlurryTank inputTank, @NotNull ISlurryTank outputTank) {
    }
}

