/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class RecyclerRecipeBuilder
extends MekanismRecipeBuilder<RecyclerRecipeBuilder> {
    private final ItemStackIngredient input;
    private final ItemStack chanceOutput;
    private final double chance;

    protected RecyclerRecipeBuilder(ItemStackIngredient input, ItemStack chanceOutput, double chance) {
        super(ResourceLocation.fromNamespaceAndPath((String)"mekmm", (String)"recycler"));
        this.input = input;
        this.chanceOutput = chanceOutput;
        this.chance = chance;
    }

    public static RecyclerRecipeBuilder recycler(ItemStackIngredient input, ItemStack chanceOutput, double chance) {
        if (chanceOutput.m_41619_()) {
            throw new IllegalArgumentException("This recycler recipe requires a non empty output.");
        }
        if (chance < 0.0 || chance > 1.0) {
            throw new IllegalArgumentException("Output chance must be at least zero and at most one.");
        }
        return new RecyclerRecipeBuilder(input, chanceOutput, chance);
    }

    protected MekanismRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new RecyclerRecipeResult(id);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, (ItemLike)this.chanceOutput.m_41720_());
    }

    public class RecyclerRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected RecyclerRecipeResult(ResourceLocation id) {
            super((MekanismRecipeBuilder)RecyclerRecipeBuilder.this, id);
        }

        public void m_7917_(@NotNull JsonObject json) {
            json.add("input", RecyclerRecipeBuilder.this.input.serialize());
            json.add("output", SerializerHelper.serializeItemStack((ItemStack)RecyclerRecipeBuilder.this.chanceOutput));
            json.addProperty("chance", (Number)RecyclerRecipeBuilder.this.chance);
        }
    }
}

