/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class PlantingRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, GasStack> {
    private final ItemStackIngredient itemInput;
    private final ChemicalStackIngredient.GasStackIngredient gasInput;
    public final ItemStack mainOutput;
    public final ItemStack secondaryOutput;

    protected PlantingRecipe(ResourceLocation id, ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack mainOutput, ItemStack secondaryOutput) {
        super(id);
        this.itemInput = Objects.requireNonNull(itemInput, "Input cannot be null.");
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        Objects.requireNonNull(mainOutput, "Main output cannot be null.");
        Objects.requireNonNull(secondaryOutput, "Secondary output cannot be null.");
        if (mainOutput.m_41619_()) {
            throw new IllegalArgumentException("Main output cannot be null.");
        }
        this.mainOutput = mainOutput.m_41777_();
        this.secondaryOutput = secondaryOutput.m_41777_();
    }

    @Override
    public boolean test(ItemStack itemStack, GasStack gasStack) {
        return this.itemInput.test((Object)itemStack) && this.gasInput.test((Object)gasStack);
    }

    @Contract(value="_, _ -> new", pure=true)
    public PlantingStationRecipeOutput getOutput(ItemStack item, GasStack gas) {
        return new PlantingStationRecipeOutput(this.mainOutput.m_41777_(), this.secondaryOutput.m_41777_());
    }

    public List<PlantingStationRecipeOutput> getOutputDefinition() {
        return Collections.singletonList(new PlantingStationRecipeOutput(this.mainOutput, this.secondaryOutput));
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public ChemicalStackIngredient.GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    public ItemStack getMainOutput() {
        return this.mainOutput;
    }

    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput.m_41619_() ? ItemStack.f_41583_ : this.secondaryOutput;
    }

    public boolean m_142505_() {
        return this.getItemInput().hasNoMatchingInstances() && this.getGasInput().hasNoMatchingInstances();
    }

    public void logMissingTags() {
        this.itemInput.logMissingTags();
        this.gasInput.logMissingTags();
    }

    public void write(FriendlyByteBuf buffer) {
        this.itemInput.write(buffer);
        this.gasInput.write(buffer);
        buffer.m_130055_(this.mainOutput);
        buffer.m_130055_(this.secondaryOutput);
    }

    public record PlantingStationRecipeOutput(@NotNull ItemStack first, @NotNull ItemStack second) {
        public PlantingStationRecipeOutput(@NotNull ItemStack first, @NotNull ItemStack second) {
            Objects.requireNonNull(first, "First output cannot be null.");
            if (first.m_41619_()) {
                throw new IllegalArgumentException("First output cannot be null");
            }
        }
    }
}

