/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class StamperRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, ItemStack> {
    private final ItemStackIngredient input;
    private final ItemStackIngredient mold;
    private final ItemStack output;

    protected StamperRecipe(ResourceLocation id, ItemStackIngredient input, ItemStackIngredient mold, ItemStack output) {
        super(id);
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        this.mold = Objects.requireNonNull(mold, "Mold cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.m_41619_()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.m_41777_();
    }

    @Override
    public boolean test(ItemStack input, ItemStack mold) {
        return this.input.test((Object)input) && this.mold.test((Object)mold);
    }

    public ItemStackIngredient getInput() {
        return this.input;
    }

    public ItemStackIngredient getMold() {
        return this.mold;
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(@NotNull ItemStack input, @NotNull ItemStack mold) {
        return this.output.m_41777_();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public boolean m_142505_() {
        return this.input.hasNoMatchingInstances() || this.mold.hasNoMatchingInstances();
    }

    public void logMissingTags() {
        this.input.logMissingTags();
        this.mold.logMissingTags();
    }

    public void write(FriendlyByteBuf buffer) {
        this.input.write(buffer);
        this.mold.write(buffer);
        buffer.m_130055_(this.output);
    }
}

