/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import com.jerry.mekmm.api.recipes.StamperRecipe;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class StamperCachedRecipe
extends CachedRecipe<StamperRecipe> {
    private final IInputHandler<ItemStack> inputHandler;
    private final IInputHandler<ItemStack> moldHandler;
    private final IOutputHandler<ItemStack> outputHandler;
    private final Predicate<ItemStack> inputEmptyCheck;
    private final Predicate<ItemStack> moldInputEmptyCheck;
    private final Supplier<? extends InputIngredient<ItemStack>> inputSupplier;
    private final Supplier<? extends InputIngredient<ItemStack>> moldInputSupplier;
    private final BiFunction<ItemStack, ItemStack, ItemStack> outputGetter;
    private final Predicate<ItemStack> outputEmptyCheck;
    private final BiConsumer<ItemStack, ItemStack> inputsSetter;
    private final Consumer<ItemStack> outputSetter;
    @Nullable
    private ItemStack input;
    @Nullable
    private ItemStack moldInput;
    @Nullable
    private ItemStack output;

    protected StamperCachedRecipe(StamperRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<ItemStack> inputHandler, IInputHandler<ItemStack> moldHandler, IOutputHandler<ItemStack> outputHandler, Supplier<InputIngredient<ItemStack>> inputSupplier, Supplier<InputIngredient<ItemStack>> moldInputSupplier, BiFunction<ItemStack, ItemStack, ItemStack> outputGetter, Predicate<ItemStack> inputEmptyCheck, Predicate<ItemStack> moldInputEmptyCheck, Predicate<ItemStack> outputEmptyCheck) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.moldHandler = Objects.requireNonNull(moldHandler, "Mold input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input ingredient supplier cannot be null.");
        this.moldInputSupplier = Objects.requireNonNull(moldInputSupplier, "Mold input ingredient supplier cannot be null.");
        this.outputGetter = Objects.requireNonNull(outputGetter, "Output getter cannot be null.");
        this.inputEmptyCheck = Objects.requireNonNull(inputEmptyCheck, "Input empty check cannot be null.");
        this.moldInputEmptyCheck = Objects.requireNonNull(moldInputEmptyCheck, "Mold input empty check cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
        this.inputsSetter = (input, mold) -> {
            this.input = input;
            this.moldInput = mold;
        };
        this.outputSetter = output -> {
            this.output = output;
        };
    }

    public static StamperCachedRecipe createCache(StamperRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> inputHandler, IInputHandler<@NotNull ItemStack> moldInputHandler, IOutputHandler<@NotNull ItemStack> outputHandler) {
        return new StamperCachedRecipe(recipe, recheckAllErrors, inputHandler, moldInputHandler, outputHandler, recipe::getInput, recipe::getMold, recipe::getOutput, ItemStack::m_41619_, ItemStack::m_41619_, ItemStack::m_41619_);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        CachedRecipeHelper.twoInputCalculateOperationsThisTick((CachedRecipe.OperationTracker)tracker, this.inputHandler, this.inputSupplier, this.moldHandler, this.moldInputSupplier, this.inputsSetter, this.outputHandler, this.outputGetter, this.outputSetter, this.inputEmptyCheck, this.moldInputEmptyCheck);
    }

    public boolean isInputValid() {
        ItemStack input = (ItemStack)this.inputHandler.getInput();
        if (this.inputEmptyCheck.test(input)) {
            return false;
        }
        ItemStack secondaryInput = (ItemStack)this.moldHandler.getInput();
        return !this.moldInputEmptyCheck.test(secondaryInput) && ((StamperRecipe)this.recipe).test(input, secondaryInput);
    }

    protected void finishProcessing(int operations) {
        if (!(this.input == null || this.moldInput == null || this.output == null || this.inputEmptyCheck.test(this.input) || this.moldInputEmptyCheck.test(this.moldInput) || this.outputEmptyCheck.test(this.output))) {
            this.inputHandler.use((Object)this.input, operations);
            this.outputHandler.handleOutput((Object)this.output, operations);
        }
    }
}

