/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.config;

import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedConfigValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class MoreMachineGeneralConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedConfigValue<List<? extends String>> itemReplicatorRecipe;
    public final CachedConfigValue<List<? extends String>> fluidReplicatorRecipe;
    public final CachedIntValue gasCollectAmount;

    MoreMachineGeneralConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General Config. This config is synced from server to client.").push("general");
        builder.comment("Custom Replicator Recipes").push("replicator_recipes");
        this.itemReplicatorRecipe = CachedConfigValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The recipes added here will be added to the item replicator. Write using modid:registeredName#amount, # followed by the amount(not null or zero) of UU matter consumed. For example:[\"minecraft:stone#10\",\"mekanism:basic_bin#100\"]").defineListAllowEmpty(Collections.singletonList("itemReplicatorRecipe"), ArrayList::new, e -> {
            String list;
            return e instanceof String && ValidatorUtils.validateList(list = (String)e);
        }));
        this.fluidReplicatorRecipe = CachedConfigValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The recipes added here will be added to the fluid replicator. Write using modid:registeredName#amount, # followed by the amount(not null or zero) of UU matter consumed. For example:[\"minecraft:water#10\",\"mekanism:heavy_water#100\"]").defineListAllowEmpty("fluidReplicatorRecipe", ArrayList::new, e -> {
            String list;
            return e instanceof String && ValidatorUtils.validateList(list = (String)e);
        }));
        builder.pop();
        this.gasCollectAmount = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("mB of Unstable Dimensional Gas collected by the Ambient Gas Collector.").defineInRange("gasCollectAmount", 1, 1, 1000));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "general";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

