/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jerry.mekmm.api.recipes.StamperRecipe;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class StamperRecipeSerializer<RECIPE extends StamperRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public StamperRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)input);
        JsonArray mold = GsonHelper.m_13885_((JsonObject)json, (String)"mold") ? GsonHelper.m_13933_((JsonObject)json, (String)"mold") : GsonHelper.m_13930_((JsonObject)json, (String)"mold");
        ItemStackIngredient moldIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)mold);
        ItemStack output = SerializerHelper.getItemStack((JsonObject)json, (String)"output");
        if (output.m_41619_()) {
            throw new JsonSyntaxException("Stamper recipe output must not be empty.");
        }
        return this.factory.create(recipeId, inputIngredient, moldIngredient, output);
    }

    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient input = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStackIngredient mold = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStack output = buffer.m_130267_();
            return this.factory.create(recipeId, input, mold, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading stamper recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((StamperRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing stamper recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends StamperRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStackIngredient var3, ItemStack var4);
    }
}

