/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.api.recipes.cache.PlantingCacheRecipe;
import com.jerry.mekmm.api.recipes.outputs.MoreMachineOutputHelper;
import com.jerry.mekmm.common.inventory.slot.MoreMachineFactoryInputInventorySlot;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityPlantingStation;
import com.jerry.mekmm.common.upgrade.PlantingUpgradeData;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPlantingFactory
extends TileEntityMoreMachineFactory<PlantingRecipe>
implements IHasDumpButton,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, PlantingRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, TileEntityPlantingStation.NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private IInputHandler<@NotNull ItemStack>[] inputHandlers;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private IOutputHandler<PlantingRecipe.PlantingStationRecipeOutput>[] outputHandlers;
    GasInventorySlot gasSlot;
    IGasTank gasTank;
    private final ItemStackConstantChemicalToItemStackCachedRecipe.ChemicalUsageMultiplier chemicalUsageMultiplier;
    private long baseTotalUsage;
    private final long[] usedSoFar;

    public TileEntityPlantingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.setupInputConfig(TransmissionType.GAS, (Object)this.gasTank);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.gasTank, RelativeSide.RIGHT).setCanEject(false);
        this.baseTotalUsage = 200L;
        this.usedSoFar = new long[this.tier.processes];
        this.chemicalUsageMultiplier = (usedSoFar, operatingTicks) -> {
            long baseRemaining = this.baseTotalUsage - usedSoFar;
            int remainingTicks = this.getTicksRequired() - operatingTicks;
            if (baseRemaining < (long)remainingTicks) {
                return 0L;
            }
            if (baseRemaining == (long)remainingTicks) {
                return 1L;
            }
            return Math.max(MathUtils.clampToLong((double)((double)baseRemaining / (double)remainingTicks)), 0L);
        };
        this.gasInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.gasTank);
    }

    @Nullable
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityPlantingFactory)this).getDirection(), () -> ((TileEntityPlantingFactory)this).getConfig());
        this.gasTank = (IGasTank)ChemicalTankBuilder.GAS.create(210L * (long)this.tier.processes, arg_0 -> ((TileEntityPlantingFactory)this).containsRecipeB(arg_0), this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.gasTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        int baseX;
        this.inputHandlers = new IInputHandler[this.tier.processes];
        this.outputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new TileEntityMoreMachineFactory.ProcessInfo[this.tier.processes];
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < this.tier.processes; ++i) {
            int xPos = baseX + i * baseXMult;
            OutputInventorySlot outputSlot = OutputInventorySlot.at((IContentsListener)updateSortingListener, (int)xPos, (int)57);
            OutputInventorySlot secondaryOutputSlot = OutputInventorySlot.at((IContentsListener)updateSortingListener, (int)xPos, (int)77);
            MoreMachineFactoryInputInventorySlot inputSlot = MoreMachineFactoryInputInventorySlot.create(this, i, (IInventorySlot)outputSlot, (IInventorySlot)secondaryOutputSlot, (IContentsListener)this.recipeCacheLookupMonitors[i], xPos, 13);
            int index = i;
            ((MoreMachineFactoryInputInventorySlot)builder.addSlot((IInventorySlot)inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            ((OutputInventorySlot)builder.addSlot((IInventorySlot)outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, index)));
            ((OutputInventorySlot)builder.addSlot((IInventorySlot)secondaryOutputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(TileEntityPlantingStation.NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR, index)));
            this.inputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
            this.outputHandlers[i] = MoreMachineOutputHelper.getOutputHandler((IInventorySlot)outputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, (IInventorySlot)secondaryOutputSlot, TileEntityPlantingStation.NOT_ENOUGH_SPACE_SECONDARY_OUTPUT_ERROR);
            this.processInfoSlots[i] = new TileEntityMoreMachineFactory.ProcessInfo(i, inputSlot, (IInventorySlot)outputSlot, (IInventorySlot)secondaryOutputSlot);
        }
        this.gasSlot = GasInventorySlot.fillOrConvert((IGasTank)this.gasTank, () -> ((TileEntityPlantingFactory)this).m_58904_(), (IContentsListener)listener, (int)7, (int)77);
        builder.addSlot((IInventorySlot)this.gasSlot);
    }

    public IGasTank getGasTank() {
        return this.gasTank;
    }

    @Nullable
    public GasInventorySlot getExtraSlot() {
        return this.gasSlot;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<PlantingRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, PlantingRecipe>> getRecipeType() {
        return MoreMachineRecipeType.PLANTING;
    }

    @Nullable
    public PlantingRecipe getRecipe(int cacheIndex) {
        return (PlantingRecipe)this.findFirstRecipe((IInputHandler)this.inputHandlers[cacheIndex], (IInputHandler)this.gasInputHandler);
    }

    @NotNull
    public CachedRecipe<PlantingRecipe> createNewCachedRecipe(@NotNull PlantingRecipe recipe, int cacheIndex) {
        return PlantingCacheRecipe.create(recipe, this.recheckAllRecipeErrors[cacheIndex], this.inputHandlers[cacheIndex], this.gasInputHandler, this.chemicalUsageMultiplier, used -> {
            this.usedSoFar[cacheIndex] = used;
        }, this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityPlantingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<PlantingRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            PlantingRecipe cachedRecipe = (PlantingRecipe)cached.getRecipe();
            return cachedRecipe.getItemInput().testType((Object)stack) && (this.gasTank.isEmpty() || cachedRecipe.getGasInput().testType((Object)((GasStack)this.gasTank.getStack())));
        }
        return false;
    }

    @Override
    @Nullable
    protected PlantingRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        GasStack gasInput = (GasStack)this.gasTank.getStack();
        ItemStack output = secondaryOutputSlot == null ? ItemStack.f_41583_ : secondaryOutputSlot.getStack();
        return (PlantingRecipe)((InputRecipeCache.ItemChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)fallbackInput, (Object)gasInput, recipe -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(fallbackInput, gasInput).first(), (ItemStack)output));
    }

    @Override
    protected void handleSecondaryFuel() {
        this.gasSlot.fillTankOrConvert();
    }

    @Override
    protected int getNeededInput(PlantingRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount((Object)inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, (GasStack)this.gasTank.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("usedSoFar", 12)) {
            long[] savedUsed = nbt.m_128467_("usedSoFar");
            if (this.tier.processes != savedUsed.length) {
                Arrays.fill(this.usedSoFar, 0L);
            }
            for (int i = 0; i < this.tier.processes && i < savedUsed.length; ++i) {
                this.usedSoFar[i] = savedUsed[i];
            }
        } else {
            Arrays.fill(this.usedSoFar, 0L);
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128388_("usedSoFar", Arrays.copyOf(this.usedSoFar, this.usedSoFar.length));
    }

    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar[cacheIndex];
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof PlantingUpgradeData) {
            PlantingUpgradeData data = (PlantingUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.gasTank.deserializeNBT(data.stored.serializeNBT());
            this.gasSlot.deserializeNBT(data.gasSlot.serializeNBT());
            System.arraycopy(data.usedSoFar, 0, this.usedSoFar, 0, data.usedSoFar.length);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public PlantingUpgradeData getUpgradeData() {
        return new PlantingUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.usedSoFar, this.gasTank, this.energySlot, this.gasSlot, this.inputSlots, this.outputSlots, this.isSorting(), (List<ITileComponent>)this.getComponents());
    }

    public void dump() {
        this.gasTank.setEmpty();
    }
}

