/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.api.recipes.StamperRecipe;
import com.jerry.mekmm.api.recipes.cache.StamperCachedRecipe;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.tile.factory.TileEntityItemToItemMoreMachineFactory;
import com.jerry.mekmm.common.upgrade.StamperUpgradeData;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityStampingFactory
extends TileEntityItemToItemMoreMachineFactory<StamperRecipe>
implements IDoubleRecipeLookupHandler.DoubleItemRecipeLookupHandler<StamperRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getSecondaryInput"}, docPlaceholder="secondary input slot")
    InputInventorySlot moldSlot;

    public TileEntityStampingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.extraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.moldSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.moldSlot = InputInventorySlot.at(arg_0 -> ((TileEntityStampingFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener), (int)7, (int)57);
        builder.addSlot((IInventorySlot)this.moldSlot);
        this.moldSlot.setSlotType(ContainerSlotType.EXTRA);
    }

    @Nullable
    protected InputInventorySlot getExtraSlot() {
        return this.moldSlot;
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeAB(stack, this.moldSlot.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(StamperRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount((Object)inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<StamperRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            StamperRecipe cachedRecipe = (StamperRecipe)cached.getRecipe();
            return cachedRecipe.getInput().testType((Object)stack) && (this.moldSlot.isEmpty() || cachedRecipe.getMold().testType((Object)this.moldSlot.getStack()));
        }
        return false;
    }

    @Override
    protected StamperRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        ItemStack extra = this.moldSlot.getStack();
        ItemStack output = outputSlot.getStack();
        return (StamperRecipe)((InputRecipeCache.DoubleItem)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)fallbackInput, (Object)this.moldSlot.getStack(), recipe -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(fallbackInput, extra), (ItemStack)output));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<StamperRecipe, InputRecipeCache.DoubleItem<StamperRecipe>> getRecipeType() {
        return MoreMachineRecipeType.STAMPING;
    }

    @Nullable
    public StamperRecipe getRecipe(int cacheIndex) {
        return (StamperRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.extraInputHandler);
    }

    @NotNull
    public CachedRecipe<StamperRecipe> createNewCachedRecipe(@NotNull StamperRecipe recipe, int cacheIndex) {
        return StamperCachedRecipe.createCache(recipe, this.recheckAllRecipeErrors[cacheIndex], (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.extraInputHandler, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityStampingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof StamperUpgradeData) {
            StamperUpgradeData data = (StamperUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.moldSlot.deserializeNBT(data.moldSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public StamperUpgradeData getUpgradeData() {
        return new StamperUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.moldSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

