/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineGas;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAmbientGasCollector
extends TileEntityMekanism
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final int MAX_CHEMICAL = 10000;
    private static final int BASE_OUTPUT_RATE = 256;
    public IGasTank chemicalTank;
    @NotNull
    private GasStack activeType = GasStack.EMPTY;
    public int ticksRequired = 19;
    public int operatingTicks;
    private boolean usedEnergy = false;
    private int outputRate = 256;
    private boolean noBlocking = true;
    private MachineEnergyContainer<TileEntityAmbientGasCollector> energyContainer;
    GasInventorySlot chemicalSlot;
    EnergyInventorySlot energySlot;

    public TileEntityAmbientGasCollector(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.AMBIENT_GAS_COLLECTOR, pos, state);
    }

    @Nullable
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(() -> ((TileEntityAmbientGasCollector)this).getDirection());
        this.chemicalTank = (IGasTank)ChemicalTankBuilder.GAS.output(10000L, listener);
        builder.addTank((IChemicalTank)this.chemicalTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((TileEntityAmbientGasCollector)this).getDirection());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityAmbientGasCollector)this).getDirection());
        this.chemicalSlot = GasInventorySlot.drain((IGasTank)this.chemicalTank, (IContentsListener)listener, (int)28, (int)35);
        builder.addSlot((IInventorySlot)this.chemicalSlot, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAmbientGasCollector)this).m_58904_(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        this.chemicalSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.chemicalSlot.drainTank();
        FloatingLong clientEnergyUsed = FloatingLong.ZERO;
        if (MekanismUtils.canFunction((TileEntityMekanism)this) && (this.chemicalTank.isEmpty() || (long)this.estimateIncrementAmount() <= this.chemicalTank.getNeeded()) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            if (!this.activeType.isEmpty()) {
                clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            }
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.suck(this.f_58858_.m_121945_(Direction.UP))) {
                    if (clientEnergyUsed.isZero()) {
                        clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                    }
                } else {
                    this.reset();
                }
            }
        }
        boolean bl = this.usedEnergy = !clientEnergyUsed.isZero();
        if (!this.chemicalTank.isEmpty()) {
            ChemicalUtil.emit(Collections.singleton(Direction.UP), (IChemicalTank)this.chemicalTank, (BlockEntity)this, (long)this.outputRate);
        }
    }

    public int estimateIncrementAmount() {
        return 1;
    }

    private boolean suck(BlockPos pos) {
        BlockState blockState;
        Block block;
        Optional state = WorldUtils.getBlockState((BlockGetter)this.f_58857_, (BlockPos)pos);
        if (state.isPresent() && this.isAir(block = (blockState = (BlockState)state.get()).m_60734_())) {
            GasStack gasStack;
            this.activeType = gasStack = new GasStack(MoreMachineGas.UNSTABLE_DIMENSIONAL_GAS, (long)MoreMachineConfig.general.gasCollectAmount.get());
            this.chemicalTank.insert((ChemicalStack)gasStack, Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    public boolean isAir(Block block) {
        this.noBlocking = block == Blocks.f_50016_;
        return this.noBlocking;
    }

    public boolean getNotBlocking() {
        return this.noBlocking;
    }

    public void reset() {
        this.activeType = GasStack.EMPTY;
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        if (!this.activeType.isEmpty()) {
            nbtTags.m_128365_("gas", (Tag)this.activeType.write(new CompoundTag()));
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.operatingTicks = nbt.m_128451_("progress");
        NBTUtils.setGasStackIfPresent((CompoundTag)nbt, (String)"gas", gas -> {
            this.activeType = gas;
        });
    }

    public InteractionResult onSneakRightClick(Player player) {
        this.reset();
        player.m_5661_((Component)MekanismLang.PUMP_RESET.translate(new Object[0]), true);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean canPulse() {
        return true;
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)19);
            this.outputRate = 256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.chemicalTank.getStored(), (long)this.chemicalTank.getCapacity());
    }

    protected boolean makesComparatorDirty(SubstanceType type) {
        return type == SubstanceType.GAS;
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public MachineEnergyContainer<TileEntityAmbientGasCollector> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    @NotNull
    public GasStack getActiveType() {
        return this.activeType;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::getNotBlocking, value -> {
            this.noBlocking = value;
        }));
        container.track((ISyncableData)SyncableGasStack.create(this::getActiveType, value -> {
            this.activeType = value;
        }));
    }
}

