/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.RecyclerRecipe;
import com.jerry.mekmm.api.recipes.cache.MoreMachineOneInputCachedRecipe;
import com.jerry.mekmm.api.recipes.outputs.MoreMachineOutputHelper;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityRecycler
extends TileEntityProgressMachine<RecyclerRecipe>
implements ISingleRecipeLookupHandler.ItemRecipeLookupHandler<RecyclerRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int BASE_TICKS_REQUIRED = 200;
    private final IOutputHandler<@NotNull RecyclerRecipe.ChanceOutput> chanceOutputHandler;
    private final IInputHandler<@NotNull ItemStack> inputHandler;
    private MachineEnergyContainer<TileEntityRecycler> energyContainer;
    InputInventorySlot inputSlot;
    OutputInventorySlot chanceOutputSlot;
    EnergyInventorySlot energySlot;

    public TileEntityRecycler(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.RECYCLER, pos, state, TRACKED_ERROR_TYPES, 200);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.ENERGY});
        this.configComponent.setupItemIOConfig(Collections.singletonList(this.inputSlot), Collections.singletonList(this.chanceOutputSlot), (IInventorySlot)this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.inputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.chanceOutputHandler = MoreMachineOutputHelper.getOutputHandler((IInventorySlot)this.chanceOutputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityRecycler)this).getDirection(), () -> ((TileEntityRecycler)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityRecycler)this).getDirection(), () -> ((TileEntityRecycler)this).getConfig());
        this.inputSlot = InputInventorySlot.at(arg_0 -> ((TileEntityRecycler)this).containsRecipe(arg_0), (IContentsListener)recipeCacheListener, (int)64, (int)17);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.chanceOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)116, (int)35);
        ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.chanceOutputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE)));
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityRecycler)this).m_58904_(), (IContentsListener)listener, (int)64, (int)53);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @NotNull
    public IMekanismRecipeTypeProvider<RecyclerRecipe, InputRecipeCache.SingleItem<RecyclerRecipe>> getRecipeType() {
        return MoreMachineRecipeType.RECYCLING;
    }

    @Nullable
    public RecyclerRecipe getRecipe(int cacheIndex) {
        return (RecyclerRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @NotNull
    public CachedRecipe<RecyclerRecipe> createNewCachedRecipe(@NotNull RecyclerRecipe recipe, int cacheIndex) {
        return MoreMachineOneInputCachedRecipe.recycler(recipe, this.recheckAllRecipeErrors, this.inputHandler, this.chanceOutputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityRecycler)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityRecycler)this).getTicksRequired()).setOnFinish(() -> ((TileEntityRecycler)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    public MachineEnergyContainer<TileEntityRecycler> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean isConfigurationDataCompatible(BlockEntityType<?> tileType) {
        return super.isConfigurationDataCompatible(tileType) || MoreMachineUtils.isSameMMTypeFactory(this.getBlockType(), tileType);
    }

    @NotNull
    public MachineUpgradeData getUpgradeData() {
        return new MachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), this.energySlot, this.inputSlot, this.chanceOutputSlot, this.getComponents());
    }
}

