/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;

public class BaseGolemModel<T extends BaseGolem>
extends DefaultedEntityGeoModel<T> {
    private final boolean turnsHead;
    private final int maxHeadRotation;
    private final ResourceLocation textureDamaged;
    private final ResourceLocation textureVeryDamaged;

    public BaseGolemModel(RegistryEntry<EntityType<T>> golem, boolean turnsHead, int maxHeadRotation) {
        this(BaseGolemRenderer.name(golem), BaseGolemRenderer.texture(golem), BaseGolemRenderer.name(golem), turnsHead, maxHeadRotation);
    }

    public BaseGolemModel(ResourceLocation model, ResourceLocation texture, ResourceLocation animation, boolean turnsHead, int maxHeadRotation) {
        this(model, new ResourceLocation(texture.m_135827_(), "%s_1".formatted(texture.m_135815_())), new ResourceLocation(texture.m_135827_(), "textures/entity/%s_2.png".formatted(texture.m_135815_())), new ResourceLocation(texture.m_135827_(), "textures/entity/%s_3.png".formatted(texture.m_135815_())), animation, turnsHead, maxHeadRotation);
    }

    public BaseGolemModel(ResourceLocation model, ResourceLocation texture, ResourceLocation textureDamaged, ResourceLocation textureVeryDamaged, ResourceLocation animation, boolean turnsHead, int maxHeadRotation) {
        super(model, turnsHead);
        this.withAltTexture(texture);
        this.withAltAnimations(animation);
        this.turnsHead = turnsHead;
        this.textureDamaged = textureDamaged;
        this.textureVeryDamaged = textureVeryDamaged;
        this.maxHeadRotation = maxHeadRotation;
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("head_rotation");
        if (head == null) {
            return;
        }
        if (head.getChildBones().isEmpty()) {
            return;
        }
        Optional headRotation = head.getChildBones().stream().findFirst();
        if (headRotation.isEmpty()) {
            return;
        }
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        ((CoreGeoBone)headRotation.get()).setRotX(Mth.m_14036_((float)entityData.headPitch(), (float)(-this.maxHeadRotation), (float)this.maxHeadRotation) * ((float)Math.PI / 180));
        ((CoreGeoBone)headRotation.get()).setRotY(Mth.m_14036_((float)entityData.netHeadYaw(), (float)(-this.maxHeadRotation), (float)this.maxHeadRotation) * ((float)Math.PI / 180));
    }

    public ResourceLocation getTextureResource(T golem) {
        return switch (((BaseGolem)((Object)golem)).getCrackiness()) {
            default -> throw new IncompatibleClassChangeError();
            case IronGolem.Crackiness.NONE, IronGolem.Crackiness.LOW -> super.getTextureResource(golem);
            case IronGolem.Crackiness.MEDIUM -> this.textureDamaged;
            case IronGolem.Crackiness.HIGH -> this.textureVeryDamaged;
        };
    }
}

