/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CandleGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class CandleGolemBlock
extends AbstractCandleBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final Vec3 OFFSET = new Vec3(0.5, 0.5625, 0.5);
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.m_49796_((double)10.5, (double)0.0, (double)6.5, (double)11.5, (double)3.0, (double)9.5), Block.m_49796_((double)4.5, (double)0.0, (double)6.5, (double)5.5, (double)3.0, (double)9.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.m_49796_((double)6.5, (double)0.0, (double)10.5, (double)9.5, (double)3.0, (double)11.5), Block.m_49796_((double)6.5, (double)0.0, (double)4.5, (double)9.5, (double)3.0, (double)5.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.m_49796_((double)4.5, (double)0.0, (double)6.5, (double)5.5, (double)3.0, (double)9.5), Block.m_49796_((double)10.5, (double)0.0, (double)6.5, (double)11.5, (double)3.0, (double)9.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), Block.m_49796_((double)6.5, (double)0.0, (double)4.5, (double)9.5, (double)3.0, (double)5.5), Block.m_49796_((double)6.5, (double)0.0, (double)10.5, (double)9.5, (double)3.0, (double)11.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public CandleGolemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_151895_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, f_151895_, WATERLOGGED});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (level.m_276867_(pos)) {
            this.spawnGolem(level, pos, state);
            level.m_46961_(pos, false);
        }
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return List.of(OFFSET);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isFlintAndSteel;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!(((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || ((Boolean)state.m_61143_((Property)f_151895_)).booleanValue() || stack.m_41619_() || !(isFlintAndSteel = stack.m_41720_() instanceof FlintAndSteelItem) && !(stack.m_41720_() instanceof FireChargeItem))) {
            if (!level.m_5776_()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_151895_, (Comparable)Boolean.valueOf(true)));
                level.m_5594_(null, pos, isFlintAndSteel ? SoundEvents.f_11942_ : SoundEvents.f_11874_, player.m_5720_(), 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
                if (isFlintAndSteel) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        this.spawnGolem(level, pos, state);
        level.m_46961_(pos, false);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private void spawnGolem(Level level, BlockPos pos, BlockState state) {
        CandleGolem golem = (CandleGolem)((EntityType)ModEntityTypes.CANDLE_GOLEM.get()).m_20615_(level);
        if (golem == null) {
            return;
        }
        golem.setLit((Boolean)level.m_8055_(pos).m_61143_((Property)f_151895_));
        golem.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, ((Direction)state.m_61143_((Property)FACING)).m_122435_(), 0.0f);
        level.m_7967_((Entity)golem);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().equals(Fluids.f_76193_)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ConstantComponents.CANDLE_GOLEM_TOOLTIP);
    }
}

