/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.entities.golems.TerracottaGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class ClayGolemStatueBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.m_49796_((double)9.6, (double)0.0, (double)3.0, (double)12.6, (double)3.0, (double)6.0), Block.m_49796_((double)3.5, (double)0.0, (double)3.0, (double)6.5, (double)3.0, (double)6.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)2.5, (double)0.0, (double)6.0, (double)4.5, (double)6.0, (double)10.0), Block.m_49796_((double)11.5, (double)0.0, (double)6.0, (double)13.5, (double)6.0, (double)10.0), Block.m_49796_((double)6.5, (double)2.0, (double)2.2, (double)9.5, (double)7.0, (double)4.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.m_49796_((double)10.0, (double)0.0, (double)9.6, (double)13.0, (double)3.0, (double)12.6), Block.m_49796_((double)10.0, (double)0.0, (double)3.5, (double)13.0, (double)3.0, (double)6.5), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)6.0, (double)0.0, (double)2.5, (double)10.0, (double)6.0, (double)4.5), Block.m_49796_((double)6.0, (double)0.0, (double)11.5, (double)10.0, (double)6.0, (double)13.5), Block.m_49796_((double)11.8, (double)2.0, (double)6.5, (double)13.8, (double)7.0, (double)9.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)3.4, (double)0.0, (double)10.0, (double)6.4, (double)3.0, (double)13.0), Block.m_49796_((double)9.5, (double)0.0, (double)10.0, (double)12.5, (double)3.0, (double)13.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)11.5, (double)0.0, (double)6.0, (double)13.5, (double)6.0, (double)10.0), Block.m_49796_((double)2.5, (double)0.0, (double)6.0, (double)4.5, (double)6.0, (double)10.0), Block.m_49796_((double)6.5, (double)2.0, (double)11.8, (double)9.5, (double)7.0, (double)13.8)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.4, (double)6.0, (double)3.0, (double)6.4), Block.m_49796_((double)3.0, (double)0.0, (double)9.5, (double)6.0, (double)3.0, (double)12.5), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)6.0, (double)0.0, (double)11.5, (double)10.0, (double)6.0, (double)13.5), Block.m_49796_((double)6.0, (double)0.0, (double)2.5, (double)10.0, (double)6.0, (double)4.5), Block.m_49796_((double)2.2, (double)2.0, (double)6.5, (double)4.2, (double)7.0, (double)9.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ClayGolemStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (level.m_276867_(pos)) {
            this.spawnGolem(level, pos, state);
            level.m_46961_(pos, false);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().equals(Fluids.f_76193_)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.BLOCK, pos) > 11 - state.m_60739_((BlockGetter)level, pos)) {
            this.spawnGolem((Level)level, pos, state);
            return;
        }
        if (((Biome)level.m_204166_(pos).m_203334_()).m_47554_() > 1.0f) {
            this.spawnGolem((Level)level, pos, state);
        }
    }

    private void spawnGolem(Level level, BlockPos pos, BlockState state) {
        TerracottaGolem golem = (TerracottaGolem)((EntityType)ModEntityTypes.TERRACOTTA_GOLEM.get()).m_20615_(level);
        if (golem == null) {
            return;
        }
        golem.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, ((Direction)state.m_61143_((Property)f_54117_)).m_122435_(), 0.0f);
        level.m_7967_((Entity)golem);
        level.m_46961_(pos, false);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ConstantComponents.CLAY_GOLEM_STATUE_TOOLTIP);
    }
}

