/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.CandleFlameProjectile;
import tech.alexnijjar.golemoverhaul.common.tags.ModItemTags;

public class CandleGolem
extends BaseGolem
implements RangedAttackMob {
    private static final float HEALTH_LOSS_PER_SHOT = 0.02f;
    private static final EntityDataAccessor<Boolean> ID_LIT = SynchedEntityData.m_135353_(CandleGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ID_SITTING = SynchedEntityData.m_135353_(CandleGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RangedAttackGoal rangedAttackGoal = new CandleGolemRangedAttackGoal(this, 1.0, 20, 15.0f);

    public CandleGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 4;
        this.f_21344_ = new CandleGolemGroundPathNavigation();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public PlayState getMoveAnimation(AnimationState<BaseGolem> state, boolean moving) {
        return state.setAndContinue(moving ? ConstantAnimations.WALK : (this.isSitting() ? ConstantAnimations.SITTING_IDLE : ConstantAnimations.IDLE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LIT, (Object)false);
        this.f_19804_.m_135372_(ID_SITTING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Lit", this.isLit());
        compound.m_128379_("Sitting", this.isSitting());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLit(compound.m_128471_("Lit"));
        this.setSitting(compound.m_128471_("Sitting"));
    }

    @Override
    public boolean canMeleeAttack() {
        return !this.canBeLit();
    }

    @Override
    public boolean canTarget() {
        return this.isLit() || !this.canBeLit();
    }

    public boolean isLit() {
        return this.canBeLit() && (Boolean)this.f_19804_.m_135370_(ID_LIT) != false;
    }

    public void setLit(boolean lit) {
        this.f_19804_.m_135381_(ID_LIT, (Object)lit);
        this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
        if (lit) {
            this.f_21345_.m_25352_(2, (Goal)this.rangedAttackGoal);
        }
        this.updateAttackGoals();
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(ID_SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(ID_SITTING, (Object)sitting);
        this.m_21051_(Attributes.f_22278_).m_22100_(sitting ? 1.0 : 0.0);
    }

    public boolean canBeLit() {
        return this.getCrackiness() != IronGolem.Crackiness.HIGH;
    }

    @Override
    public boolean hasAttackAnimation() {
        return false;
    }

    public void m_20093_() {
        super.m_20093_();
        this.setLit(true);
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
        if (damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            this.setLit(true);
        }
        if (this.isSitting()) {
            damageAmount *= 0.1f;
        }
        super.m_6475_(damageSource, damageAmount);
        this.updateAttackGoals();
    }

    public void m_252836_() {
        super.m_252836_();
        if (this.isLit()) {
            this.setLit(false);
            this.m_5496_(SoundEvents.f_11937_, 1.0f, 2.0f);
        }
    }

    @Override
    public int getAttackTicks() {
        return 10;
    }

    @Override
    public boolean canRepair(ItemStack stack) {
        return stack.m_204117_(ModItemTags.WAX);
    }

    @Override
    public float getRepairItemHealAmount() {
        return 5.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.f_144178_;
    }

    public void m_6504_(LivingEntity target, float velocity) {
        CandleFlameProjectile projectile = new CandleFlameProjectile(this.m_9236_(), (LivingEntity)this);
        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20186_() - projectile.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(x * x + z * z) * 0.2;
        projectile.m_6686_(x, y + distance, z, 0.4f, 5.0f);
        this.m_9236_().m_7967_((Entity)projectile);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, this.m_5720_(), 0.3f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
        this.m_21153_(this.m_21223_() - 0.02f);
    }

    public void m_8119_() {
        if (this.isSitting()) {
            this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
            this.f_21344_.m_26573_();
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.isLit() && this.f_19797_ % 10 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_(), 0.0, 0.02, 0.0);
            }
        } else if (this.m_20070_()) {
            this.setLit(false);
        }
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (super.m_6071_(player, hand).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_() && stack.m_41619_()) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        if (this.isLit()) {
            if (stack.m_41619_()) {
                this.m_252836_();
                return InteractionResult.SUCCESS;
            }
        } else if (this.canBeLit()) {
            if (stack.m_41720_() instanceof FlintAndSteelItem) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.m_216990_(SoundEvents.f_11942_);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() instanceof FireChargeItem) {
                stack.m_41774_(1);
                this.m_216990_(SoundEvents.f_11874_);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(0.25, 0.0, 0.25);
    }

    private class CandleGolemRangedAttackGoal
    extends RangedAttackGoal {
        public CandleGolemRangedAttackGoal(RangedAttackMob rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
        }

        public boolean m_8036_() {
            return CandleGolem.this.canBeLit() && super.m_8036_();
        }
    }

    private class CandleGolemGroundPathNavigation
    extends GroundPathNavigation {
        public CandleGolemGroundPathNavigation() {
            super((Mob)CandleGolem.this, CandleGolem.this.m_9236_());
        }

        protected boolean m_7632_() {
            return !CandleGolem.this.isSitting() && super.m_7632_();
        }

        public boolean m_26536_(@Nullable Path path, double speed) {
            return !CandleGolem.this.isSitting() && super.m_26536_(path, speed);
        }
    }
}

