/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class KelpGolem
extends BaseGolem {
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private static final EntityDataAccessor<Boolean> ID_CHARGED = SynchedEntityData.m_135353_(KelpGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public KelpGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 14;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new KelpGolemMoveControl();
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.085).m_22268_(Attributes.f_22281_, 8.0);
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        GolemConstructionRecipe recipe = (GolemConstructionRecipe)level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get(), (Container)new SingleEntityInput((EntityType)ModEntityTypes.KELP_GOLEM.get()), level).orElseThrow();
        BlockPattern.BlockPatternMatch pattern = recipe.createPattern().m_61184_((LevelReader)level, pos);
        if (pattern == null) {
            return;
        }
        KelpGolem golem = (KelpGolem)((EntityType)ModEntityTypes.KELP_GOLEM.get()).m_20615_(level);
        if (golem == null) {
            return;
        }
        ModUtils.spawnGolemInWorld(level, pattern, (Entity)golem, pattern.m_61229_(1, 2, 0).m_61176_());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.getMovementController()});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 0, state -> {
            if (!this.hasAttackAnimation()) {
                return PlayState.STOP;
            }
            if (this.attackAnimationTicks == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return this.getAttackAnimation((AnimationState<? extends BaseGolem>)state);
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spin_controller", 0, state -> {
            if (!this.isCharged()) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.SPIN);
        })});
    }

    @Override
    public AnimationController<?> getMovementController() {
        return super.getMovementController().setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)ModSoundEvents.KELP_GOLEM_STEP.get(), this.m_5720_(), 1.0f, 1.0f, false));
    }

    @Override
    public PlayState handleMovementController(AnimationState<BaseGolem> state) {
        boolean moving;
        boolean bl = moving = (double)state.getLimbSwingAmount() > 0.05 || (double)state.getLimbSwingAmount() < -0.05;
        if (this.m_20069_()) {
            state.getController().setAnimation(ConstantAnimations.SWIM);
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(moving ? ConstantAnimations.WALK : (this.m_20069_() ? ConstantAnimations.IDLE_WATER : ConstantAnimations.IDLE));
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_CHARGED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Charged", this.isCharged());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCharged(compound.m_128471_("Charged"));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 3, true, false, this::shouldAttack));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(ID_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(ID_CHARGED, (Object)charged);
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.KELP_GOLEM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Override
    public boolean canFloatInWater() {
        return false;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_41910_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 5.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return (SoundEvent)ModSoundEvents.KELP_GOLEM_STEP.get();
    }

    @Override
    public int getAttackTicks() {
        return 18;
    }

    @Override
    public int getAttackDelayTicks() {
        return 6;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public void m_6075_() {
        int airSupply = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(airSupply);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 60 == 0) {
            if (this.inConduitRange()) {
                this.setCharged(true);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 1, true, true));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, true, true));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 1, true, true));
            } else {
                this.setCharged(false);
            }
        }
    }

    private boolean inConduitRange() {
        return this.m_21023_(MobEffects.f_19592_);
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_21515_() && this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_60713_(Blocks.f_49990_)) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
        super.m_5844_();
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(2.0, 0.0, 2.0);
    }

    private class KelpGolemMoveControl
    extends MoveControl {
        KelpGolemMoveControl() {
            super((Mob)KelpGolem.this);
        }

        public void m_8126_() {
            if (!KelpGolem.this.m_20069_()) {
                super.m_8126_();
                return;
            }
            LivingEntity livingEntity = KelpGolem.this.m_5448_();
            if (livingEntity != null && livingEntity.m_20186_() > KelpGolem.this.m_20186_()) {
                KelpGolem.this.m_20256_(KelpGolem.this.m_20184_().m_82520_(0.0, 0.002, 0.0));
            }
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO || KelpGolem.this.m_21573_().m_26571_()) {
                KelpGolem.this.m_7910_(0.0f);
                return;
            }
            double x = this.f_24975_ - KelpGolem.this.m_20185_();
            double y = this.f_24976_ - KelpGolem.this.m_20186_();
            double z = this.f_24977_ - KelpGolem.this.m_20189_();
            double distance = Math.sqrt(x * x + y * y + z * z);
            y /= distance;
            float h = (float)(Mth.m_14136_((double)z, (double)x) * 57.3) - 90.0f;
            KelpGolem.this.m_146922_(this.m_24991_(KelpGolem.this.m_146908_(), h, 90.0f));
            KelpGolem.this.f_20883_ = KelpGolem.this.m_146908_();
            float speed = (float)(this.f_24978_ * KelpGolem.this.m_21133_(Attributes.f_22279_));
            speed = Mth.m_14179_((float)0.125f, (float)KelpGolem.this.m_6113_(), (float)speed);
            KelpGolem.this.m_7910_(speed);
            KelpGolem.this.m_20256_(KelpGolem.this.m_20184_().m_82520_((double)(speed *= 20.0f) * x * 0.005, (double)speed * y * 0.025, (double)speed * z * 0.005));
        }
    }
}

