/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;

public abstract class BaseGolem
extends AbstractGolem
implements GeoEntity {
    public static final byte ATTACK_EVENT_ID = 4;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, true);
    private final HurtByTargetGoal hurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[]{BaseGolem.class});
    private final NearestAttackableTargetGoal<Mob> attackTargetGoal = new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, false, this::shouldAttack);
    protected int attackAnimationTicks;
    protected int attackDelayTicks = -1;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;

    protected BaseGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.updateAttackGoals();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.getMovementController()});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 0, state -> {
            if (!this.hasAttackAnimation()) {
                return PlayState.STOP;
            }
            if (this.attackAnimationTicks == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return this.getAttackAnimation((AnimationState<? extends BaseGolem>)state);
        })});
    }

    public AnimationController<?> getMovementController() {
        return new AnimationController((GeoAnimatable)this, this::handleMovementController);
    }

    public PlayState handleMovementController(AnimationState<BaseGolem> state) {
        boolean moving = (double)state.getLimbSwingAmount() > 0.05 || (double)state.getLimbSwingAmount() < -0.05;
        return this.getMoveAnimation(state, moving);
    }

    public PlayState getMoveAnimation(AnimationState<BaseGolem> state, boolean moving) {
        return state.setAndContinue(moving ? ConstantAnimations.WALK : ConstantAnimations.IDLE);
    }

    public PlayState getAttackAnimation(AnimationState<? extends BaseGolem> state) {
        return state.setAndContinue(ConstantAnimations.ATTACK);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8099_() {
        if (this.canFloatInWater()) {
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        }
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public final void updateAttackGoals() {
        this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
        this.f_21346_.m_25363_((Goal)this.hurtByTargetGoal);
        this.f_21346_.m_25363_(this.attackTargetGoal);
        if (this.canMeleeAttack()) {
            this.f_21345_.m_25352_(1, (Goal)this.meleeAttackGoal);
        }
        if (this.canTarget()) {
            this.f_21346_.m_25352_(2, (Goal)this.hurtByTargetGoal);
            this.f_21346_.m_25352_(3, this.attackTargetGoal);
        }
    }

    public boolean canMeleeAttack() {
        return this.canTarget();
    }

    public boolean canTarget() {
        return true;
    }

    public boolean shouldAttack(LivingEntity entity) {
        return entity instanceof Enemy && !(entity instanceof Creeper);
    }

    public IronGolem.Crackiness getCrackiness() {
        float fraction = this.m_21223_() / this.m_21233_();
        if ((double)fraction > 0.66) {
            return IronGolem.Crackiness.NONE;
        }
        if ((double)fraction > 0.33) {
            return IronGolem.Crackiness.MEDIUM;
        }
        return IronGolem.Crackiness.HIGH;
    }

    public boolean m_7327_(@NotNull Entity target) {
        if (this.isAttacking()) {
            return false;
        }
        this.startAttacking();
        this.sendAttackEvent();
        return this.hasDelayedAttack() || super.m_7327_(target);
    }

    public void startAttacking() {
        if (this.isAttacking()) {
            return;
        }
        this.attackAnimationTicks = this.getAttackTicks();
        if (this.hasDelayedAttack()) {
            this.attackDelayTicks = this.getAttackDelayTicks();
        }
    }

    public boolean isAttacking() {
        return this.attackAnimationTicks > 0 || this.attackDelayTicks > 0;
    }

    public void sendAttackEvent() {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.startAttacking();
        }
    }

    private void tickAttackDelay() {
        LivingEntity target = this.m_5448_();
        if (this.attackDelayTicks == 0) {
            if (target != null && this.m_217066_(target)) {
                this.actuallyAttackAfterDelay(target);
            }
            this.performAdditionalAttacks(target);
            this.attackDelayTicks = -1;
        }
    }

    public void actuallyAttackAfterDelay(LivingEntity target) {
        super.m_7327_((Entity)target);
    }

    public void performAdditionalAttacks(LivingEntity target) {
    }

    public boolean canFloatInWater() {
        return true;
    }

    public boolean hasAttackAnimation() {
        return true;
    }

    public int getAttackTicks() {
        return 0;
    }

    public int getAttackDelayTicks() {
        return 0;
    }

    public final boolean hasDelayedAttack() {
        return this.getAttackDelayTicks() > 0;
    }

    public Item getRepairItem() {
        return Items.f_41852_;
    }

    public abstract float getRepairItemHealAmount();

    public boolean canRepair(ItemStack stack) {
        return stack.m_150930_(this.getRepairItem());
    }

    public SoundEvent getRepairSound() {
        return SoundEvents.f_12009_;
    }

    public final void removeAndAddDeathParticles() {
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void m_8107_() {
        super.m_8107_();
        this.attackAnimationTicks = Math.max(0, this.attackAnimationTicks - 1);
        this.attackDelayTicks = Math.max(-1, this.attackDelayTicks - 1);
        if (this.hasDelayedAttack()) {
            this.tickAttackDelay();
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.canRepair(stack)) {
            return InteractionResult.PASS;
        }
        float health = this.m_21223_();
        this.m_5634_(this.getRepairItemHealAmount());
        if (this.m_21223_() == health) {
            return InteractionResult.PASS;
        }
        float pitch = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
        this.m_5496_(this.getRepairSound(), 1.0f, pitch);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.updateAttackGoals();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.updateAttackGoals();
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11915_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected AABB getAttackBoundingBox() {
        AABB aabb;
        Entity vehicle = this.m_20202_();
        if (vehicle != null) {
            AABB vehicleAabb = vehicle.m_20191_();
            AABB selfAabb = this.m_20191_();
            aabb = new AABB(Math.min(selfAabb.f_82288_, vehicleAabb.f_82288_), selfAabb.f_82289_, Math.min(selfAabb.f_82290_, vehicleAabb.f_82290_), Math.max(selfAabb.f_82291_, vehicleAabb.f_82291_), selfAabb.f_82292_, Math.max(selfAabb.f_82293_, vehicleAabb.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        return aabb.m_82377_(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    public boolean m_217066_(LivingEntity entity) {
        return this.getAttackBoundingBox().m_82381_(entity.m_20191_());
    }
}

