/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.events;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.List;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import tech.alexnijjar.golemoverhaul.common.entities.IShearable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.KelpGolem;

public class ModEvents {
    public static void init() {
        ModEvents.registerShearInteractions();
        ModEvents.registerKelpGolemPlacementDetection();
        ModEvents.registerHayGolemTramplePrevention();
    }

    private static void registerShearInteractions() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (!(entity instanceof IShearable)) {
                return EventResult.pass();
            }
            IShearable target = (IShearable)entity;
            if (entity.m_9236_().f_46443_) {
                return EventResult.pass();
            }
            ItemStack stack = player.m_21120_(hand);
            if (!(stack.m_41720_() instanceof ShearsItem)) {
                return EventResult.pass();
            }
            if (!target.isShearable()) {
                return EventResult.interruptFalse();
            }
            List<ItemStack> drops = target.onSheared();
            drops.forEach(dropStack -> {
                ItemEntity droppedItem = entity.m_5552_(dropStack, 1.0f);
                if (droppedItem != null) {
                    Random rand = new Random();
                    droppedItem.m_20256_(droppedItem.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
            });
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return EventResult.interruptTrue();
        });
    }

    private static void registerKelpGolemPlacementDetection() {
        BlockEvent.PLACE.register((level, blockPos, blockState, entity) -> {
            if (!(level instanceof ServerLevel)) {
                return EventResult.pass();
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockState.m_60713_(Blocks.f_50577_) || blockState.m_60713_(Blocks.f_50386_)) {
                serverLevel.m_7654_().execute(() -> KelpGolem.trySpawnGolem(level, blockPos));
            }
            return EventResult.pass();
        });
    }

    private static void registerHayGolemTramplePrevention() {
        InteractionEvent.FARMLAND_TRAMPLE.register((level, blockPos, blockState, v, entity) -> {
            if (level.m_5776_()) {
                return EventResult.pass();
            }
            AABB bounds = blockState.m_60812_((BlockGetter)level, blockPos).m_83215_().m_82338_(blockPos).m_82400_(10.0);
            if (!level.m_45976_(HayGolem.class, bounds).isEmpty()) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }
}

