/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;

public class GolemConstructionRecipe
implements Recipe<SingleEntityInput> {
    private final ResourceLocation id;
    private final List<String> pattern;
    private final Map<String, ResourceKey<Block>> key;
    private final ResourceKey<EntityType<?>> entity;
    private final ResourceKey<Item> item;
    private final boolean visualOnly;
    private final float blockScale;
    private final float entityScale;

    public GolemConstructionRecipe(ResourceLocation id, List<String> pattern, Map<String, ResourceKey<Block>> key, ResourceKey<EntityType<?>> entity, ResourceKey<Item> item, boolean visualOnly, float blockScale, float entityScale) {
        this.id = id;
        this.pattern = pattern;
        this.key = key;
        this.entity = entity;
        this.item = item;
        this.visualOnly = visualOnly;
        this.blockScale = blockScale;
        this.entityScale = entityScale;
    }

    public boolean matches(SingleEntityInput input, @NotNull Level level) {
        Optional key = BuiltInRegistries.f_256780_.m_7854_(input.entity());
        return key.isPresent() && ((ResourceKey)key.get()).equals(this.entity);
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleEntityInput container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public BlockPattern createPattern() {
        BlockPatternBuilder builder = BlockPatternBuilder.m_61243_();
        builder.m_61247_(this.pattern.toArray(new String[0]));
        this.key.forEach((key, block_key) -> builder.m_61244_(key.charAt(0), BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Objects.requireNonNull((Block)BuiltInRegistries.f_256975_.m_6246_(block_key))))));
        return builder.m_61249_();
    }

    public Map<String, ResourceKey<Block>> getKey() {
        return this.key;
    }

    public ResourceKey<Item> getItem() {
        return this.item;
    }

    public float getBlockScale() {
        return this.blockScale;
    }

    public float getEntityScale() {
        return this.entityScale;
    }

    public List<String> getPattern() {
        return this.pattern;
    }

    public ResourceKey<EntityType<?>> getEntity() {
        return this.entity;
    }

    public static class Serializer
    implements RecipeSerializer<GolemConstructionRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public GolemConstructionRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject serializedRecipe) {
            JsonArray patternJson = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"pattern");
            List<String> pattern = StreamSupport.stream(patternJson.spliterator(), false).map(element -> GsonHelper.m_13805_((JsonElement)element, (String)"pattern entry")).collect(Collectors.toList());
            JsonObject keyJson = GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"key");
            Map<String, ResourceKey<Block>> key = keyJson.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                ResourceLocation blockId = new ResourceLocation(GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)"key value"));
                return ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)blockId);
            }));
            ResourceLocation entityId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)serializedRecipe, (String)"entity"));
            ResourceKey entity = ResourceKey.m_135785_((ResourceKey)Registries.f_256939_, (ResourceLocation)entityId);
            ResourceLocation itemId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)serializedRecipe, (String)"item"));
            ResourceKey item = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)itemId);
            boolean visualOnly = GsonHelper.m_13855_((JsonObject)serializedRecipe, (String)"visualOnly", (boolean)false);
            float blockScale = GsonHelper.m_13820_((JsonObject)serializedRecipe, (String)"blockScale", (float)1.0f);
            float entityScale = GsonHelper.m_13820_((JsonObject)serializedRecipe, (String)"entityScale", (float)1.0f);
            return new GolemConstructionRecipe(recipeId, pattern, key, entity, (ResourceKey<Item>)item, visualOnly, blockScale, entityScale);
        }

        @Nullable
        public GolemConstructionRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            List pattern = buffer.m_236845_(FriendlyByteBuf::m_130277_);
            Map key = buffer.m_236847_(FriendlyByteBuf::m_130277_, buf -> ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)buf.m_130281_()));
            ResourceKey entity = ResourceKey.m_135785_((ResourceKey)Registries.f_256939_, (ResourceLocation)buffer.m_130281_());
            ResourceKey item = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)buffer.m_130281_());
            boolean visualOnly = buffer.readBoolean();
            float blockScale = buffer.readFloat();
            float entityScale = buffer.readFloat();
            return new GolemConstructionRecipe(recipeId, pattern, key, entity, (ResourceKey<Item>)item, visualOnly, blockScale, entityScale);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull GolemConstructionRecipe recipe) {
            buffer.m_236828_(recipe.pattern, FriendlyByteBuf::m_130070_);
            buffer.m_236831_(recipe.key, FriendlyByteBuf::m_130070_, (buf, resourceKey) -> buf.m_130085_(resourceKey.m_135782_()));
            buffer.m_130085_(recipe.entity.m_135782_());
            buffer.m_130085_(recipe.item.m_135782_());
            buffer.writeBoolean(recipe.visualOnly);
            buffer.writeFloat(recipe.blockScale);
            buffer.writeFloat(recipe.entityScale);
        }
    }

    public static class Type
    implements RecipeType<GolemConstructionRecipe> {
        public static final Type INSTANCE = new Type();
    }
}

