/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.mixins.common;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.BarrelGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

@Mixin(value={SinglePoolElement.class})
public abstract class SinglePoolElementMixin {
    private static final ResourceLocation IRON_GOLEM_STRUCTURE = new ResourceLocation("village/common/iron_golem");
    @Shadow
    @Final
    protected Either<ResourceLocation, StructureTemplate> f_210411_;

    @Shadow
    protected abstract StructurePlaceSettings m_207169_(Rotation var1, BoundingBox var2, boolean var3);

    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Rotation;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/util/RandomSource;Z)Z"}, at={@At(value="RETURN")})
    private void golemoverhaul$place(StructureTemplateManager structureTemplateManager, WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator generator, BlockPos offset, BlockPos pos, Rotation rotation, BoundingBox box, RandomSource random, boolean keepJigsaws, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (worldGenLevel.m_5776_()) {
            return;
        }
        this.f_210411_.left().ifPresent(templateLocation -> {
            EntityType hayGolemEntityType;
            if (!templateLocation.equals((Object)IRON_GOLEM_STRUCTURE)) {
                return;
            }
            StructurePlaceSettings settings = this.m_207169_(rotation, box, keepJigsaws);
            EntityType barrelGolemEntityType = (EntityType)ModEntityTypes.BARREL_GOLEM.get();
            if (BarrelGolem.checkMobSpawnRules((EntityType<? extends Mob>)barrelGolemEntityType, (LevelAccessor)worldGenLevel, MobSpawnType.SPAWNER, offset, worldGenLevel.m_213780_())) {
                this.spawnAdditionalGolem(barrelGolemEntityType, worldGenLevel, settings, offset);
            }
            if (HayGolem.checkMobSpawnRules((EntityType<? extends Mob>)(hayGolemEntityType = (EntityType)ModEntityTypes.HAY_GOLEM.get()), (LevelAccessor)worldGenLevel, MobSpawnType.SPAWNER, offset, worldGenLevel.m_213780_())) {
                this.spawnAdditionalGolem(hayGolemEntityType, worldGenLevel, settings, offset);
            }
        });
    }

    private <T extends BaseGolem> void spawnAdditionalGolem(EntityType<T> entityType, WorldGenLevel worldGenLevel, StructurePlaceSettings settings, BlockPos offset) {
        BaseGolem golem = (BaseGolem)entityType.m_20615_((Level)worldGenLevel.m_6018_());
        if (golem == null) {
            return;
        }
        Vec3 spawnPos = new Vec3((double)offset.m_123341_() + 0.5, (double)(offset.m_123342_() + 1), (double)offset.m_123343_() + 0.5);
        float yRot = golem.m_7890_(settings.m_74404_());
        golem.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, yRot += golem.m_6961_(settings.m_74401_()) - golem.m_146908_(), golem.m_146909_());
        if (settings.m_74414_()) {
            golem.m_6518_((ServerLevelAccessor)worldGenLevel, worldGenLevel.m_6436_(BlockPos.m_274446_((Position)spawnPos)), MobSpawnType.STRUCTURE, null, null);
        }
        worldGenLevel.m_47205_((Entity)golem);
    }
}

