/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.projectiles;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CandleGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.TerracottaGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class CandleFlameProjectile
extends ThrowableItemProjectile {
    public CandleFlameProjectile(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public CandleFlameProjectile(Level level, LivingEntity owner) {
        super((EntityType)ModEntityTypes.CANDLE_FLAME.get(), level);
        this.setOwner((Entity)owner);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof CandleGolem) {
            return;
        }
        if (result.getEntity() instanceof TerracottaGolem) {
            return;
        }
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 3.0f);
        entity.igniteForSeconds(5.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            this.playSound(SoundEvents.SHULKER_BULLET_HIT, 1.0f, 1.0f);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return Items.FIRE_CHARGE;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected double getDefaultGravity() {
        return super.getDefaultGravity();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.tickCount % 5 == 0) {
            this.spawnParticles();
        }
        if (!this.level().isClientSide() && this.tickCount > 100) {
            this.discard();
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            double x = this.getX() + this.random.nextDouble() * 0.5;
            double y = this.getY() + this.random.nextDouble() * 0.5;
            double z = this.getZ() + this.random.nextDouble() * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

