/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tech.alexnijjar.golemoverhaul.datagen.provider.client.ModItemModelProvider;
import tech.alexnijjar.golemoverhaul.datagen.provider.client.ModLangProvider;
import tech.alexnijjar.golemoverhaul.datagen.provider.server.ModBlockTagProvider;
import tech.alexnijjar.golemoverhaul.datagen.provider.server.ModEntityTypeTagProvider;
import tech.alexnijjar.golemoverhaul.datagen.provider.server.ModItemTagProvider;
import tech.alexnijjar.golemoverhaul.datagen.provider.server.ModLootTableProvider;
import tech.alexnijjar.golemoverhaul.datagen.provider.server.ModRecipeProvider;

@EventBusSubscriber(modid="golemoverhaul", bus=EventBusSubscriber.Bus.MOD)
public final class GolemOverhaulDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

