/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.datagen.provider.client;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.codehaus.plexus.util.StringUtils;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.registry.ModBlocks;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModItems;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(PackOutput output) {
        super(output, "golemoverhaul", "en_us");
    }

    protected void addTranslations() {
        ModBlocks.BLOCKS.stream().forEach(entry -> this.addBlock((Supplier)entry, StringUtils.capitaliseAllWords((String)entry.getId().getPath().replace("_", " "))));
        ModItems.ITEMS.stream().filter(i -> !(i.get() instanceof BlockItem)).forEach(entry -> this.addItem((Supplier)entry, StringUtils.capitaliseAllWords((String)entry.getId().getPath().replace("_", " "))));
        ModEntityTypes.ENTITY_TYPES.stream().forEach(entry -> this.addEntityType((Supplier)entry, StringUtils.capitaliseAllWords((String)entry.getId().getPath().replace("_", " "))));
        this.add("itemGroup.golemoverhaul.main", "Golem Overhaul");
        this.add(ConstantComponents.NETHERITE_GOLEM_SUMMON_KEY.getString(), "Summon Netherite Golem");
        this.add(ConstantComponents.GOLEM_OVERHAUL_CATEGORY.getString(), "Golem Overhaul");
        this.add(ConstantComponents.GOLEM_CONSTRUCTION_CATEGORY.getString(), "Golem Construction");
        this.add(ConstantComponents.CANDLE_GOLEM_TOOLTIP.getString(), "Right-click to transform into a Candle Golem");
        this.add(ConstantComponents.CLAY_GOLEM_STATUE_TOOLTIP.getString(), "Can be melted like ice into a Terracotta Golem");
        this.add("subtitles.golemoverhaul.entity.coal_golem.ambient", "Coal Golem burns");
        this.add("subtitles.golemoverhaul.entity.coal_golem.hurt", "Coal Golem hurts");
        this.add("subtitles.golemoverhaul.entity.coal_golem.death", "Coal Golem dies");
        this.add("subtitles.golemoverhaul.entity.coal_golem.explode", "Coal Golem explodes");
        this.add("subtitles.golemoverhaul.entity.barrel_golem.barter", "Barrel Golem barters");
        this.add("subtitles.golemoverhaul.entity.netherite_golem.hurt", "Netherite Golem hurts");
        this.add("subtitles.golemoverhaul.entity.netherite_golem.hit", "Netherite Golem is hit");
        this.add("subtitles.golemoverhaul.entity.netherite_golem.death", "Netherite Golem dies");
        this.add("subtitles.golemoverhaul.entity.netherite_golem.step", "Netherite Golem steps");
        this.add("subtitles.golemoverhaul.entity.netherite_golem.summon", "Netherite Golem is summoned");
        this.add("subtitles.golemoverhaul.entity.hay_golem.hurt", "Hay Golem hurts");
        this.add("subtitles.golemoverhaul.entity.hay_golem.death", "Hay Golem dies");
        this.add("subtitles.golemoverhaul.entity.kelp_golem.death", "Kelp Golem dies");
        this.add("subtitles.golemoverhaul.entity.kelp_golem.step", "Kelp Golem steps");
        this.add("config.golemoverhaul.allowSpawning", "Allow Spawning");
        this.add("config.golemoverhaul.spawnBarrelGolems", "Spawn Barrel Golems");
        this.add("config.golemoverhaul.spawnCoalGolems", "Spawn Coal Golems");
        this.add("config.golemoverhaul.spawnHayGolems", "Spawn Hay Golems");
        this.add("config.golemoverhaul.spawnHoneyGolems", "Spawn Honey Golems");
        this.add("config.golemoverhaul.spawnSlimeGolems", "Spawn Slime Golems");
        this.add("config.golemoverhaul.spawnTerracottaGolems", "Spawn Terracotta Golems");
        this.add("config.golemoverhaul.title", "Golem Overhaul");
        this.add("config.golemoverhaul.client.title", "Golem Overhaul Client");
        this.add("config.golemoverhaul.description", "Golem overhaul adds awesome Golems!");
        this.add("config.golemoverhaul.links.github", "GitHub");
        this.add("config.golemoverhaul.links.discord", "Discord");
        this.add("config.golemoverhaul.links.modrinth", "Modrinth");
        this.add("config.golemoverhaul.links.curseforge", "CurseForge");
    }
}

