/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.tt432.dokimobs.CosPackFile;
import io.github.tt432.eyelib.Eyelib;
import io.github.tt432.eyelib.client.animation.Animation;
import io.github.tt432.eyelib.client.animation.bedrock.BrAnimationEntry;
import io.github.tt432.eyelib.client.animation.bedrock.controller.BrAnimationController;
import io.github.tt432.eyelib.client.entity.BrClientEntity;
import io.github.tt432.eyelib.client.loader.BrClientEntityLoader;
import io.github.tt432.eyelib.client.model.bedrock.BrModelEntry;
import io.github.tt432.eyelib.client.render.controller.RenderControllerEntry;
import io.github.tt432.eyelib.util.client.NativeImages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CosPackFileV1(String version, List<FileEntry> entries) implements CosPackFile
{
    private static final Logger log = LoggerFactory.getLogger(CosPackFileV1.class);
    public static final Codec<CosPackFileV1> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("version").forGetter(CosPackFileV1::version), (App)FileEntry.CODEC.listOf().fieldOf("entries").forGetter(CosPackFileV1::entries)).apply((Applicative)ins, CosPackFileV1::new));

    public static CosPackFileV1 from(BrClientEntity ... entities) {
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        for (BrClientEntity entity : entities) {
            Object value2;
            if (entity == null) continue;
            HashMap<String, Animation> animations = new HashMap<String, Animation>();
            for (Object value2 : entity.animations().values()) {
                animations.put((String)value2, (Animation)Eyelib.getAnimationManager().get((String)value2));
            }
            ArrayList<BrModelEntry> models = new ArrayList<BrModelEntry>();
            value2 = entity.geometry().values().iterator();
            while (value2.hasNext()) {
                String value3 = (String)value2.next();
                Object object = Eyelib.getModelManager().get(value3);
                if (!(object instanceof BrModelEntry)) continue;
                BrModelEntry model = (BrModelEntry)object;
                models.add(model);
            }
            HashMap<String, RenderControllerEntry> renderControllers = new HashMap<String, RenderControllerEntry>();
            for (String renderController : entity.render_controllers()) {
                renderControllers.put(renderController, (RenderControllerEntry)Eyelib.getRenderControllerManager().get(renderController));
            }
            HashMap<String, String> textureBase64s = new HashMap<String, String>();
            for (String value4 : entity.textures().values()) {
                String base64 = (String)NativeImages.downloadImage((ResourceLocation)ResourceLocation.parse((String)value4), ni -> {
                    try {
                        return Base64.getEncoder().encodeToString(ni.asByteArray());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                if (base64 == null) {
                    base64 = (String)NativeImages.downloadImage((ResourceLocation)ResourceLocation.parse((String)CosPackFileV1.replacePng(value4, ".png", ".tga")), ni -> {
                        try {
                            return Base64.getEncoder().encodeToString(ni.asByteArray());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                if (base64 == null) continue;
                textureBase64s.put(value4, base64);
            }
            entries.add(new FileEntry(entity.identifier(), entity, animations, renderControllers, models, textureBase64s));
        }
        return new CosPackFileV1("1", entries);
    }

    static String replacePng(String originalString, String old, String newStr) {
        int lastIndexOfDot = originalString.lastIndexOf(old);
        if (lastIndexOfDot != -1) {
            String beforeDot = originalString.substring(0, lastIndexOfDot);
            return beforeDot + newStr;
        }
        return originalString;
    }

    @Override
    public void export(String path) {
        if (!new File(path).exists()) {
            try {
                new File(path).createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.entries.forEach(FileEntry::onExport);
        try (FileOutputStream fos = new FileOutputStream(path);){
            DataResult jsonElementDataResult = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
            JsonElement orThrow = (JsonElement)jsonElementDataResult.getOrThrow(s -> {
                log.error(s);
                return new IllegalArgumentException((String)s);
            });
            fos.write(new Gson().toJson(orThrow).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void onLoad() {
        this.entries.forEach(FileEntry::onLoad);
    }

    record FileEntry(String identifier, BrClientEntity entity, Map<String, Animation> animations, Map<String, RenderControllerEntry> renderControllers, List<BrModelEntry> models, Map<String, String> textureBase64s) {
        public static final Codec<FileEntry> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("identifier").forGetter(FileEntry::identifier), (App)BrClientEntity.CODEC.fieldOf("entity").forGetter(FileEntry::entity), (App)Codec.dispatchedMap((Codec)Codec.STRING, name -> name.startsWith("animation") ? BrAnimationEntry.codec((String)name) : BrAnimationController.CODEC).fieldOf("animations").forGetter(o -> o.animations), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)RenderControllerEntry.CODEC).fieldOf("renderControllers").forGetter(FileEntry::renderControllers), (App)BrModelEntry.CODEC.listOf().fieldOf("models").forGetter(FileEntry::models), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("textures").forGetter(FileEntry::textureBase64s)).apply((Applicative)ins, FileEntry::new));

        public void onLoad() {
            BrClientEntityLoader.INSTANCE.getEntities().put(ResourceLocation.parse((String)this.entity.identifier()), this.entity);
            this.animations.forEach((k, v) -> Eyelib.getAnimationManager().put(k, v));
            this.models.forEach(m -> Eyelib.getModelManager().put(m.name(), m));
            this.renderControllers.forEach((k, v) -> Eyelib.getRenderControllerManager().put(k, v));
            this.textureBase64s.forEach((k, v) -> {
                try {
                    NativeImage ni = NativeImage.read((byte[])Base64.getDecoder().decode((String)v));
                    Minecraft.getInstance().getTextureManager().register(ResourceLocation.parse((String)k), (AbstractTexture)new DynamicTexture(ni));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public void onExport() {
            this.animations.entrySet().removeIf(e -> e.getValue() == null);
        }
    }
}

