/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.tt432.dokimobs.config.DokimobsConfig;
import io.github.tt432.dokimobs.data.DokiData;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.MobSpawnType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

public record EntityDokiData(boolean init, boolean doki) {
    public static final Codec<EntityDokiData> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.BOOL.fieldOf("init").forGetter(EntityDokiData::init), (App)Codec.BOOL.fieldOf("doki").forGetter(EntityDokiData::doki)).apply((Applicative)ins, EntityDokiData::new));
    public static final StreamCodec<ByteBuf, EntityDokiData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, EntityDokiData::init, (StreamCodec)ByteBufCodecs.BOOL, EntityDokiData::doki, EntityDokiData::new);

    public EntityDokiData withInit(boolean init) {
        return this.init == init ? this : new EntityDokiData(init, this.doki);
    }

    public EntityDokiData withDoki(boolean doki) {
        return this.doki == doki ? this : new EntityDokiData(this.init, doki);
    }

    @EventBusSubscriber
    public static final class Events {
        @SubscribeEvent
        public static void onFinalizeSpawn(FinalizeSpawnEvent event) {
            if (event.getSpawnType() == MobSpawnType.SPAWN_EGG) {
                EntityDokiData data = (EntityDokiData)event.getEntity().getData(DokiData.DOKI);
                if (!event.getLevel().isClientSide() && !data.init) {
                    data = data.withInit(true).withDoki(Math.random() < (Double)DokimobsConfig.CONFIG.spawnChance.get());
                    event.getEntity().setData(DokiData.DOKI, (Object)data);
                }
            }
        }

        @SubscribeEvent
        public static void onEvent(EntityJoinLevelEvent event) {
            EntityDokiData data = (EntityDokiData)event.getEntity().getData(DokiData.DOKI);
            if (!data.init && !event.getLevel().isClientSide) {
                data = data.withInit(true).withDoki(Math.random() < (Double)DokimobsConfig.CONFIG.spawnChance.get());
                event.getEntity().setData(DokiData.DOKI, (Object)data);
            }
        }
    }
}

