/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.tt432.eyelib.Eyelib;
import io.github.tt432.eyelib.client.ClientTickHandler;
import io.github.tt432.eyelib.client.gui.manager.EyelibManagerScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.apache.commons.lang3.StringUtils;

public class CosPackEntitiesListPanel
extends ScrollPanel {
    private final List<EntityButton> selected = new ArrayList<EntityButton>();
    private final List<EntityButton> allEntitiesList = new ArrayList<EntityButton>();
    private final List<EntityButton> filtedEntitiesList = new ArrayList<EntityButton>();
    private boolean finished = false;
    public boolean onlyEntity = false;
    private Font font;
    String lastSearch;
    private EntityButton hoverButton;

    public CosPackEntitiesListPanel(Minecraft client, Font font, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        CompletableFuture.runAsync(() -> {
            for (ResourceLocation resourceLocation : BuiltInRegistries.ENTITY_TYPE.keySet()) {
                this.allEntitiesList.add(new EntityButton(resourceLocation.toString(), ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation)).getDescription(), ResourceLocation.fromNamespaceAndPath((String)"eyelib", (String)("icons/entities/" + resourceLocation.toString().replace(":", "/")))));
            }
            this.filtedEntitiesList.addAll(this.allEntitiesList);
            this.finished = true;
        });
        this.lastSearch = "";
        this.font = font;
    }

    public void update() {
        this.onEdited(this.lastSearch);
    }

    void onEdited(String input) {
        this.filtedEntitiesList.clear();
        for (EntityButton entityButton : this.allEntitiesList) {
            if (!StringUtils.contains((CharSequence)entityButton.key, (CharSequence)input) && !StringUtils.contains((CharSequence)entityButton.name.getString(), (CharSequence)input) || this.onlyEntity != (Eyelib.getClientEntityLoader().get(ResourceLocation.parse((String)entityButton.key)) != null)) continue;
            this.filtedEntitiesList.add(entityButton);
        }
        this.scrollDistance = 0.0f;
        this.lastSearch = input;
    }

    private int buttonPreLine() {
        return 4;
    }

    private int lineAmount() {
        return (this.filtedEntitiesList.size() - 1) / this.buttonPreLine();
    }

    private int slotSize() {
        return (this.width - this.border * 2) / 4;
    }

    protected int getContentHeight() {
        return (this.lineAmount() + 1) * this.slotSize();
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        if (!this.finished) {
            CosPackEntitiesListPanel.centeredString(guiGraphics, this.font, "\u6b63\u5728\u52a0\u8f7d", this.left, this.top, this.width, this.height);
        } else {
            int slotSize = this.slotSize();
            int renderLine = (this.height - this.border * 2) / slotSize + 2;
            float iconBorder = (float)slotSize / 30.0f;
            float iconSize = (float)slotSize - iconBorder * 2.0f;
            int line = (int)(this.scrollDistance / (float)slotSize);
            this.hoverButton = null;
            if (this.lineAmount() >= line) {
                for (int i = 0; i < renderLine; ++i) {
                    int index;
                    for (int i1 = 0; i1 < this.buttonPreLine() && (index = (line + i) * this.buttonPreLine() + i1) < this.filtedEntitiesList.size(); ++i1) {
                        int x = Math.round((float)(this.left + this.border + i1 * slotSize) + iconBorder);
                        int y = Math.round((float)(this.top + this.border) - this.scrollDistance % (float)slotSize + (float)(i * slotSize) + iconBorder);
                        int s = Math.round(iconSize);
                        EntityButton entityButton = this.filtedEntitiesList.get(index);
                        boolean hover = EyelibManagerScreen.hover((double)x, (double)y, (double)slotSize, (double)slotSize, (double)mouseX, (double)mouseY);
                        float a = !this.selected.contains(entityButton) ? entityButton.animator.getTime(ClientTickHandler.getTick(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), hover) : 1.0f;
                        CosPackEntitiesListPanel.renderEntityButton(guiGraphics, x, y, s, a, entityButton);
                        if (!EyelibManagerScreen.hover((double)x, (double)y, (double)iconSize, (double)iconSize, (double)mouseX, (double)mouseY)) continue;
                        this.hoverButton = entityButton;
                    }
                }
            }
        }
    }

    public static void renderEntityButton(GuiGraphics guiGraphics, int x, int y, int s, float a, EntityButton entityButton) {
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"eyelib", (String)"gui_bg_nine"), x, y, s, s);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"eyelib", (String)"gui_bg_nine_selected"), x, y, s, s);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(entityButton.icon, x + 4, y + 4, s - 8, s - 8);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hoverButton != null) {
            this.selected.add(this.hoverButton);
            return true;
        }
        return false;
    }

    private static void centeredString(GuiGraphics guiGraphics, Font font, String string, int x, int y, int w, int h) {
        Objects.requireNonNull(font);
        int th = 9;
        int tw = font.width(string);
        guiGraphics.drawString(font, string, x + w / 2 - tw / 2, y + h / 2 - th / 2, -1);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public List<EntityButton> getSelected() {
        return this.selected;
    }

    public EntityButton getHoverButton() {
        return this.hoverButton;
    }

    static class EntityButton {
        final String key;
        final Component name;
        final ResourceLocation icon;
        final GuiAnimator animator = new GuiAnimator(5);

        public EntityButton(String key, Component name, ResourceLocation icon) {
            this.key = key;
            this.name = name;
            this.icon = icon;
        }
    }

    static class GuiAnimator {
        public final int animTime;
        private float startStamp;
        private float timer;
        private float timerStamp;
        private boolean fadeIn;

        public final float getTime(int tick, float partialTicks, boolean state) {
            float time = (float)tick + partialTicks;
            if (state) {
                if (!this.fadeIn) {
                    this.fadeIn = true;
                    this.timerStamp = this.timer;
                    this.startStamp = time;
                }
            } else if (this.fadeIn) {
                this.fadeIn = false;
                this.timerStamp = this.timer;
                this.startStamp = time;
            }
            this.timer = Math.clamp(this.timerStamp + (float)(this.fadeIn ? 1 : -1) * (time - this.startStamp), 0.0f, (float)this.animTime);
            return Math.clamp(this.timer / (float)this.animTime, 0.0f, 1.0f);
        }

        public GuiAnimator(int animTime) {
            this.animTime = animTime;
        }
    }
}

