/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.tt432.dokimobs.screen.CosPackEntitiesListPanel;
import io.github.tt432.eyelib.client.ClientTickHandler;
import io.github.tt432.eyelib.client.gui.manager.EyelibManagerScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;

public class CosPackSelectedListView
extends ScrollPanel {
    private final List<CosPackEntitiesListPanel.EntityButton> selected;
    private final Font font;
    private CosPackEntitiesListPanel.EntityButton hoverButton;

    public CosPackSelectedListView(Minecraft client, Font font, int width, int height, int top, int left, List<CosPackEntitiesListPanel.EntityButton> selected) {
        super(client, width, height, top, left);
        this.selected = selected;
        this.font = font;
    }

    private int buttonPreLine() {
        return 4;
    }

    private int lineAmount() {
        return (this.selected.size() - 1) / this.buttonPreLine();
    }

    private int slotSize() {
        return (this.width - this.border * 2) / 4;
    }

    protected int getContentHeight() {
        return this.lineAmount() * this.slotSize();
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        int slotSize = this.slotSize();
        int renderLine = (this.height - this.border * 2) / slotSize + 2;
        float iconBorder = (float)slotSize / 30.0f;
        float iconSize = (float)slotSize - iconBorder * 2.0f;
        int line = (int)(this.scrollDistance / (float)slotSize);
        this.hoverButton = null;
        if (this.lineAmount() >= line) {
            for (int i = 0; i < renderLine; ++i) {
                int index;
                for (int i1 = 0; i1 < this.buttonPreLine() && (index = (line + i) * this.buttonPreLine() + i1) < this.selected.size(); ++i1) {
                    int x = Math.round((float)(this.left + this.border + i1 * slotSize) + iconBorder);
                    int y = Math.round((float)(this.top + this.border) - this.scrollDistance % (float)slotSize + (float)(i * slotSize) + iconBorder);
                    int s = Math.round(iconSize);
                    CosPackEntitiesListPanel.EntityButton entityButton = this.selected.get(index);
                    boolean hover = EyelibManagerScreen.hover((double)x, (double)y, (double)slotSize, (double)slotSize, (double)mouseX, (double)mouseY);
                    float a = !this.selected.contains(entityButton) ? entityButton.animator.getTime(ClientTickHandler.getTick(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), hover) : 1.0f;
                    CosPackSelectedListView.renderEntityButton(guiGraphics, x, y, s, a, entityButton);
                    if (!EyelibManagerScreen.hover((double)x, (double)y, (double)iconSize, (double)iconSize, (double)mouseX, (double)mouseY)) continue;
                    this.hoverButton = entityButton;
                }
            }
        }
    }

    public static void renderEntityButton(GuiGraphics guiGraphics, int x, int y, int s, float a, CosPackEntitiesListPanel.EntityButton entityButton) {
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"eyelib", (String)"gui_bg_nine"), x, y, s, s);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        guiGraphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)"eyelib", (String)"gui_bg_nine_selected"), x, y, s, s);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(entityButton.icon, x + 4, y + 4, s - 8, s - 8);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hoverButton != null) {
            this.selected.remove(this.hoverButton);
            return true;
        }
        return false;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public CosPackEntitiesListPanel.EntityButton getHoverButton() {
        return this.hoverButton;
    }
}

