/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs.screen;

import io.github.tt432.dokimobs.CosPackFileManager;
import io.github.tt432.dokimobs.CosPackFileV1;
import io.github.tt432.dokimobs.DMKeys;
import io.github.tt432.dokimobs.screen.CosPackEntitiesListPanel;
import io.github.tt432.dokimobs.screen.CosPackSelectedListView;
import io.github.tt432.eyelib.Eyelib;
import io.github.tt432.eyelib.client.entity.BrClientEntity;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderFrameEvent;

public class CosPackExportScreen
extends Screen {
    CosPackEntitiesListPanel panel;
    int border;

    protected CosPackExportScreen() {
        super((Component)Component.literal((String)"CosPack Export Screen"));
    }

    protected void init() {
        super.init();
        this.border = Math.round((float)this.height * 0.1f);
        Objects.requireNonNull(Minecraft.getInstance().font);
        int inputHeight = Math.round(9.0f / 0.614f);
        int leftAreaWidth = 120;
        EditBox input = new EditBox(this.minecraft.fontFilterFishy, this.border, this.border, leftAreaWidth, inputHeight, (Component)Component.empty());
        input.setMaxLength(256);
        input.setBordered(true);
        input.setResponder(this::onEdited);
        input.setCanLoseFocus(true);
        this.addRenderableWidget((GuiEventListener)input);
        int padding = Math.round((float)inputHeight * 0.1f);
        this.panel = new CosPackEntitiesListPanel(Minecraft.getInstance(), leftAreaWidth, Math.round((float)this.height * 0.8f) - (inputHeight + padding), this.border + (inputHeight + padding), this.border);
        this.addRenderableWidget((GuiEventListener)this.panel);
        this.addRenderableWidget((GuiEventListener)new CosPackSelectedListView(Minecraft.getInstance(), leftAreaWidth, Math.round((float)this.height * 0.8f), this.border, this.border + leftAreaWidth + this.border, this.panel.getSelected()));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\u5bfc\u51fa\u4e3a cospack"), b -> {
            CosPackFileV1 file = CosPackFileV1.from((BrClientEntity[])this.panel.getSelected().stream().map(s -> Eyelib.getClientEntityLoader().get(ResourceLocation.parse((String)s.key))).toArray(BrClientEntity[]::new));
            CosPackFileManager.export(file);
        }).pos(this.border * 3 + leftAreaWidth * 2, this.height - inputHeight - this.border).size(this.width - (leftAreaWidth * 2 + this.border * 4), inputHeight).build());
    }

    void onEdited(String input) {
        this.panel.onEdited(input);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static final class Events {
        @SubscribeEvent
        public static void onEvent(RenderFrameEvent.Post event) {
            if (DMKeys.openExportScreen.consumeClick()) {
                Minecraft.getInstance().setScreen((Screen)new CosPackExportScreen());
            }
        }
    }
}

