/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs;

import io.github.tt432.dokimobs.data.DokiData;
import io.github.tt432.dokimobs.data.EntityDokiData;
import io.github.tt432.eyelib.capability.EntityBehaviorData;
import io.github.tt432.eyelib.capability.EyelibAttachableData;
import io.github.tt432.eyelib.capability.RenderData;
import io.github.tt432.eyelib.common.behavior.component.MarkVariant;
import io.github.tt432.eyelib.common.behavior.component.Variant;
import io.github.tt432.eyelib.common.behavior.component.group.ComponentGroup;
import io.github.tt432.eyelib.util.data_attach.DataAttachmentHelper;
import io.github.tt432.eyelib.util.data_attach.DataAttachmentType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class TempVariantSetting {

    @Mod.EventBusSubscriber
    public static final class ClientEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onEvent(RenderLivingEvent.Pre event) {
            if (!((EntityDokiData)DataAttachmentHelper.getOrCreate((DataAttachmentType)((DataAttachmentType)DokiData.DOKI.get()), (Entity)event.getEntity())).doki()) {
                RenderData.getComponent((Entity)event.getEntity()).setUseBuiltInRenderSystem(false);
            }
        }
    }

    @Mod.EventBusSubscriber
    public static final class CommonEvents {
        static void variant(Entity entity, Variant variant) {
            EntityBehaviorData data = (EntityBehaviorData)DataAttachmentHelper.getOrCreate((DataAttachmentType)((DataAttachmentType)EyelibAttachableData.ENTITY_BEHAVIOR_DATA.get()), (Entity)entity);
            List componentGroups = data.getComponentGroups();
            if (componentGroups.isEmpty()) {
                componentGroups.add(new ComponentGroup(Map.of("a", Map.of("variant", variant))));
            }
            data.setup();
            DataAttachmentHelper.set((DataAttachmentType)((DataAttachmentType)EyelibAttachableData.ENTITY_BEHAVIOR_DATA.get()), (Entity)entity, (Object)data);
        }

        static void variant(Entity entity, Variant variant, MarkVariant markVariant) {
            EntityBehaviorData data = (EntityBehaviorData)DataAttachmentHelper.getOrCreate((DataAttachmentType)((DataAttachmentType)EyelibAttachableData.ENTITY_BEHAVIOR_DATA.get()), (Entity)entity);
            ArrayList<ComponentGroup> componentGroups = new ArrayList<ComponentGroup>();
            componentGroups.add(new ComponentGroup(Map.of("variants", Map.of("variant", variant, "mark_variant", markVariant))));
            DataAttachmentHelper.set((DataAttachmentType)((DataAttachmentType)EyelibAttachableData.ENTITY_BEHAVIOR_DATA.get()), (Entity)entity, (Object)new EntityBehaviorData(data.getBehavior(), componentGroups));
        }

        @SubscribeEvent
        public static void onEvent(LivingEvent.LivingTickEvent event) {
            Object object;
            if (!event.getEntity().m_9236_().f_46443_ && (object = event.getEntity()) instanceof VillagerDataHolder) {
                VillagerDataHolder villager = (VillagerDataHolder)object;
                Entity entity = (Entity)villager;
                Variant variant = new Variant(switch (villager.m_7141_().m_35571_().f_35600_()) {
                    case "unskilled" -> 0;
                    case "farmer" -> 1;
                    case "fisherman" -> 2;
                    case "shepherd" -> 3;
                    case "fletcher" -> 4;
                    case "librarian" -> 5;
                    case "cartographer" -> 6;
                    case "cleric" -> 7;
                    case "armorer" -> 8;
                    case "weapon_smith" -> 9;
                    case "tool_smith" -> 10;
                    case "butcher" -> 11;
                    case "leatherworker" -> 12;
                    case "stonemason" -> 13;
                    case "nitwit" -> 14;
                    default -> 0;
                });
                CommonEvents.variant(entity, variant, new MarkVariant(switch (BuiltInRegistries.f_256934_.m_7981_((Object)villager.m_7141_().m_35560_()).toString()) {
                    case "plains" -> 0;
                    case "desert" -> 1;
                    case "jungle" -> 2;
                    case "savanna" -> 3;
                    case "snow" -> 4;
                    case "swamp" -> 5;
                    case "taiga" -> 6;
                    default -> 0;
                }));
            }
        }

        @SubscribeEvent
        public static void onEvent(EntityJoinLevelEvent event) {
            if (!event.getLevel().f_46443_) {
                Entity entity = event.getEntity();
                if (entity instanceof Zombie) {
                    Zombie z = (Zombie)entity;
                    CommonEvents.variant((Entity)z, new Variant(z.m_217043_().m_188503_(3)));
                } else if (entity instanceof Llama) {
                    Llama llama = (Llama)entity;
                    CommonEvents.variant((Entity)llama, new Variant(llama.m_28554_().m_262452_()), new MarkVariant(llama instanceof TraderLlama ? 1 : 0));
                } else if (entity instanceof Fox) {
                    Fox fox = (Fox)entity;
                    if (fox.m_28554_() == Fox.Type.SNOW) {
                        int choice = CommonEvents.weightedRandom(fox.m_217043_(), new int[]{5, 1, 1, 1});
                        int result = choice == 0 ? 1 : (choice == 1 ? 9 : (choice == 2 ? 10 : (choice == 3 ? 11 : -1)));
                        CommonEvents.variant((Entity)fox, new Variant(result));
                    } else {
                        int choice = CommonEvents.weightedRandom(fox.m_217043_(), new int[]{5, 1, 1, 1, 1, 1, 1, 1});
                        int result = choice == 0 ? 0 : (choice == 1 ? 6 : (choice == 2 ? 2 : (choice == 3 ? 3 : (choice == 4 ? 4 : (choice == 5 ? 5 : (choice == 6 ? 8 : (choice == 7 ? 7 : -1)))))));
                        CommonEvents.variant((Entity)fox, new Variant(result));
                    }
                } else if (entity instanceof Chicken) {
                    Chicken chicken = (Chicken)entity;
                    CommonEvents.variant((Entity)chicken, new Variant(chicken.m_217043_().m_188503_(3)));
                } else if (entity instanceof Villager) {
                    // empty if block
                }
            }
        }

        private static int weightedRandom(RandomSource source, int[] weights) {
            int totalWeight = 0;
            for (int weight : weights) {
                totalWeight += weight;
            }
            int randomValue = source.m_188503_(totalWeight);
            int cumulativeWeight = 0;
            for (int i = 0; i < weights.length; ++i) {
                if (randomValue >= (cumulativeWeight += weights[i])) continue;
                return i;
            }
            return -1;
        }
    }
}

