/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.tt432.dokimobs.config.DokimobsConfig;
import io.github.tt432.dokimobs.data.DokiData;
import io.github.tt432.eyelib.util.codec.stream.StreamCodec;
import io.github.tt432.eyelib.util.data_attach.DataAttachmentHelper;
import io.github.tt432.eyelib.util.data_attach.DataAttachmentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public record EntityDokiData(boolean init, boolean doki) {
    public static final Codec<EntityDokiData> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.BOOL.fieldOf("init").forGetter(EntityDokiData::init), (App)Codec.BOOL.fieldOf("doki").forGetter(EntityDokiData::doki)).apply((Applicative)ins, EntityDokiData::new));
    public static final StreamCodec<EntityDokiData> STREAM_CODEC = StreamCodec.create((obj, buf) -> {
        buf.writeBoolean(obj.init());
        buf.writeBoolean(obj.doki());
    }, buf -> new EntityDokiData(buf.readBoolean(), buf.readBoolean()));

    public EntityDokiData withInit(boolean init) {
        return this.init == init ? this : new EntityDokiData(init, this.doki);
    }

    public EntityDokiData withDoki(boolean doki) {
        return this.doki == doki ? this : new EntityDokiData(this.init, doki);
    }

    @Mod.EventBusSubscriber
    public static final class Events {
        @SubscribeEvent
        public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
            if (event.getSpawnType() == MobSpawnType.SPAWN_EGG) {
                EntityDokiData data = (EntityDokiData)DataAttachmentHelper.getOrCreate((DataAttachmentType)((DataAttachmentType)DokiData.DOKI.get()), (Entity)event.getEntity());
                if (!event.getLevel().m_5776_() && !data.init) {
                    data = data.withInit(true).withDoki(Math.random() < (Double)DokimobsConfig.CONFIG.spawnChance.get());
                    DataAttachmentHelper.set((DataAttachmentType)((DataAttachmentType)DokiData.DOKI.get()), (Entity)event.getEntity(), (Object)data);
                }
            }
        }

        @SubscribeEvent
        public static void onEvent(EntityJoinLevelEvent event) {
            EntityDokiData data = (EntityDokiData)DataAttachmentHelper.getOrCreate((DataAttachmentType)((DataAttachmentType)DokiData.DOKI.get()), (Entity)event.getEntity());
            if (!data.init && !event.getLevel().f_46443_) {
                data = data.withInit(true).withDoki(Math.random() < (Double)DokimobsConfig.CONFIG.spawnChance.get());
                DataAttachmentHelper.set((DataAttachmentType)((DataAttachmentType)DokiData.DOKI.get()), (Entity)event.getEntity(), (Object)data);
            }
        }
    }
}

