/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs;

import io.github.tt432.dokimobs.data.DokiData;
import io.github.tt432.dokimobs.data.EntityDokiData;
import io.github.tt432.eyelib.capability.EntityBehaviorData;
import io.github.tt432.eyelib.capability.EyelibAttachableData;
import io.github.tt432.eyelib.capability.RenderData;
import io.github.tt432.eyelib.common.behavior.component.MarkVariant;
import io.github.tt432.eyelib.common.behavior.component.Variant;
import io.github.tt432.eyelib.common.behavior.component.group.ComponentGroup;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class TempVariantSetting {

    @EventBusSubscriber
    public static final class ClientEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onEvent(RenderLivingEvent.Pre event) {
            if (!((EntityDokiData)event.getEntity().getData(DokiData.DOKI)).doki()) {
                RenderData.getComponent((Entity)event.getEntity()).setUseBuiltInRenderSystem(false);
            }
        }
    }

    @EventBusSubscriber
    public static final class CommonEvents {
        static void variant(Entity entity, Variant variant) {
            EntityBehaviorData data = (EntityBehaviorData)entity.getData((Supplier)EyelibAttachableData.ENTITY_BEHAVIOR_DATA);
            List componentGroups = data.getComponentGroups();
            if (componentGroups.isEmpty()) {
                componentGroups.add(new ComponentGroup(Map.of("a", Map.of("variant", variant))));
            }
            data.setup();
            entity.setData((Supplier)EyelibAttachableData.ENTITY_BEHAVIOR_DATA, (Object)data);
        }

        static void variant(Entity entity, Variant variant, MarkVariant markVariant) {
            EntityBehaviorData data = (EntityBehaviorData)entity.getData((Supplier)EyelibAttachableData.ENTITY_BEHAVIOR_DATA);
            ArrayList<ComponentGroup> componentGroups = new ArrayList<ComponentGroup>();
            componentGroups.add(new ComponentGroup(Map.of("variants", Map.of("variant", variant, "mark_variant", markVariant))));
            entity.setData((Supplier)EyelibAttachableData.ENTITY_BEHAVIOR_DATA, (Object)new EntityBehaviorData(data.getBehavior(), componentGroups));
        }

        @SubscribeEvent
        public static void onEvent(EntityTickEvent.Pre event) {
            Object object;
            if (!event.getEntity().level().isClientSide && (object = event.getEntity()) instanceof VillagerDataHolder) {
                VillagerDataHolder villager = (VillagerDataHolder)object;
                Entity entity = (Entity)villager;
                Variant variant = new Variant(switch (villager.getVillagerData().getProfession().name()) {
                    case "unskilled" -> 0;
                    case "farmer" -> 1;
                    case "fisherman" -> 2;
                    case "shepherd" -> 3;
                    case "fletcher" -> 4;
                    case "librarian" -> 5;
                    case "cartographer" -> 6;
                    case "cleric" -> 7;
                    case "armorer" -> 8;
                    case "weapon_smith" -> 9;
                    case "tool_smith" -> 10;
                    case "butcher" -> 11;
                    case "leatherworker" -> 12;
                    case "stonemason" -> 13;
                    case "nitwit" -> 14;
                    default -> 0;
                });
                CommonEvents.variant(entity, variant, new MarkVariant(switch (BuiltInRegistries.VILLAGER_TYPE.getKey((Object)villager.getVillagerData().getType()).toString()) {
                    case "plains" -> 0;
                    case "desert" -> 1;
                    case "jungle" -> 2;
                    case "savanna" -> 3;
                    case "snow" -> 4;
                    case "swamp" -> 5;
                    case "taiga" -> 6;
                    default -> 0;
                }));
            }
        }

        @SubscribeEvent
        public static void onEvent(EntityJoinLevelEvent event) {
            if (!event.getLevel().isClientSide) {
                Entity entity = event.getEntity();
                Objects.requireNonNull(entity);
                Entity entity2 = entity;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Zombie.class, Llama.class, Fox.class, Chicken.class, Villager.class}, (Object)entity2, n)) {
                    case 0: {
                        Zombie z = (Zombie)entity2;
                        CommonEvents.variant((Entity)z, new Variant(z.getRandom().nextInt(3)));
                        break;
                    }
                    case 1: {
                        Llama llama = (Llama)entity2;
                        CommonEvents.variant((Entity)llama, new Variant(llama.getVariant().getId()), new MarkVariant(llama instanceof TraderLlama ? 1 : 0));
                        break;
                    }
                    case 2: {
                        Fox fox = (Fox)entity2;
                        if (fox.getVariant() == Fox.Type.SNOW) {
                            CommonEvents.variant((Entity)fox, new Variant(switch (CommonEvents.weightedRandom(fox.getRandom(), new int[]{5, 1, 1, 1})) {
                                case 0 -> 1;
                                case 1 -> 9;
                                case 2 -> 10;
                                case 3 -> 11;
                                default -> -1;
                            }));
                            break;
                        }
                        CommonEvents.variant((Entity)fox, new Variant(switch (CommonEvents.weightedRandom(fox.getRandom(), new int[]{5, 1, 1, 1, 1, 1, 1, 1})) {
                            case 0 -> 0;
                            case 1 -> 6;
                            case 2 -> 2;
                            case 3 -> 3;
                            case 4 -> 4;
                            case 5 -> 5;
                            case 6 -> 8;
                            case 7 -> 7;
                            default -> -1;
                        }));
                        break;
                    }
                    case 3: {
                        Chicken chicken = (Chicken)entity2;
                        CommonEvents.variant((Entity)chicken, new Variant(chicken.getRandom().nextInt(3)));
                        break;
                    }
                    case 4: {
                        Villager villager = (Villager)entity2;
                        break;
                    }
                }
            }
        }

        private static int weightedRandom(RandomSource source, int[] weights) {
            int totalWeight = 0;
            for (int weight : weights) {
                totalWeight += weight;
            }
            int randomValue = source.nextInt(totalWeight);
            int cumulativeWeight = 0;
            for (int i = 0; i < weights.length; ++i) {
                if (randomValue >= (cumulativeWeight += weights[i])) continue;
                return i;
            }
            return -1;
        }
    }
}

