/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.tt432.dokimobs.CosPackFile;
import io.github.tt432.dokimobs.CosPackFileV1;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class CosPackFileManager {
    private static final ExecutorService FILE_DIALOG_EXECUTOR = Executors.newSingleThreadExecutor();

    public static CosPackFile load(JsonObject object) {
        switch (object.get("version").getAsString()) {
            case "1": {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + object.get("version").getAsString());
            }
        }
        return (CosPackFileV1)CosPackFileV1.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow(false, IllegalArgumentException::new);
    }

    public static void export(CosPackFile file) {
        CosPackFileManager.fileSelectDialog("\u4fdd\u5b58\u6587\u4ef6", Path.of("pack.cospack", new String[0]), "\u5bfc\u51fa\u4e3a cospack", "*.cospack").whenComplete((path, throwable) -> path.ifPresent(p -> file.export(p.toString())));
    }

    private static CompletableFuture<Optional<Path>> fileSelectDialog(String title, @Nullable Path origin, @Nullable String filterLabel, String ... filters) {
        CompletableFuture<Optional<Path>> future = new CompletableFuture<Optional<Path>>();
        FILE_DIALOG_EXECUTOR.submit(() -> {
            String result = null;
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filterBuffer = stack.mallocPointer(filters.length);
                for (String filter : filters) {
                    filterBuffer.put(stack.UTF8((CharSequence)filter));
                }
                filterBuffer.flip();
                String path = origin != null ? origin.toAbsolutePath().toString() : null;
                result = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)path, (PointerBuffer)filterBuffer, (CharSequence)filterLabel);
            }
            future.complete(Optional.ofNullable(result).map(x$0 -> Paths.get(x$0, new String[0])));
        });
        return future;
    }

    private CosPackFileManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

