/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.dokimobs;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.tt432.dokimobs.CosPackFile;
import io.github.tt432.dokimobs.CosPackFileManager;
import io.github.tt432.eyelib.client.loader.SimpleJsonWithSuffixResourceReloadListener;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CosPackLoader
extends SimpleJsonWithSuffixResourceReloadListener {
    private static final Logger log = LoggerFactory.getLogger(CosPackLoader.class);
    public static final CosPackLoader INSTANCE = new CosPackLoader();
    private final Map<ResourceLocation, CosPackFile> files = new HashMap<ResourceLocation, CosPackFile>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    private CosPackLoader() {
        super(new GsonBuilder().setLenient().create(), "dokimobs/cospack", "cospack");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        this.files.clear();
        pObject.forEach((k, v) -> {
            CosPackFile file = CosPackFileManager.load(v.getAsJsonObject());
            file.onLoad();
            this.files.put((ResourceLocation)k, file);
        });
    }

    public Map<ResourceLocation, CosPackFile> getFiles() {
        return this.files;
    }
}

