/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.threateninglymobs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OptimizedMoveControl2
extends MoveControl {
    private static final float RAD_PER_DEG = (float)Math.PI / 180;
    private final float maxRotate;
    private float currrentRotate = 0.0f;
    private float rotIntensity;
    private float currentSpeed;

    public OptimizedMoveControl2(Mob mob, float maxRotate, float rotIntensity) {
        super(mob);
        this.maxRotate = maxRotate;
        this.rotIntensity = rotIntensity;
    }

    public OptimizedMoveControl2(Mob mob, float maxRotate) {
        super(mob);
        this.maxRotate = maxRotate;
        this.rotIntensity = 0.2f;
    }

    public OptimizedMoveControl2(Mob mob) {
        super(mob);
        this.maxRotate = 90.0f;
        this.rotIntensity = 0.2f;
    }

    public void m_8126_() {
        Mob m = this.f_24974_;
        float attributeSpeed = (float)m.m_21133_(Attributes.f_22279_);
        switch (this.f_24981_) {
            case STRAFE: {
                float targetSpeed = (float)(this.f_24978_ * (double)attributeSpeed);
                float forward = this.f_24979_;
                float right = this.f_24980_;
                float magnitudeSq = forward * forward + right * right;
                float magnitude = magnitudeSq < 1.0f ? 1.0f : Mth.m_14116_((float)magnitudeSq);
                float factor = targetSpeed / magnitude;
                float rot = m.m_146908_() * ((float)Math.PI / 180);
                float sin = Mth.m_14031_((float)rot);
                float cos = Mth.m_14089_((float)rot);
                float xMovement = (forward *= factor) * cos - (right *= factor) * sin;
                float zMovement = right * cos + forward * sin;
                if (!this.m_24996_(xMovement, zMovement)) {
                    this.f_24979_ = 1.0f;
                    this.f_24980_ = 0.0f;
                }
                m.m_7910_(targetSpeed);
                m.m_21564_(this.f_24979_);
                m.m_21570_(this.f_24980_);
                this.f_24981_ = MoveControl.Operation.WAIT;
                break;
            }
            case MOVE_TO: {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double dx = this.f_24975_ - m.m_20185_();
                double dz = this.f_24977_ - m.m_20189_();
                double dy = this.f_24976_ - m.m_20186_();
                double distSq = dx * dx + dy * dy + dz * dz;
                if (distSq < 2.500000277905201E-7) {
                    this.currentSpeed = Math.max(this.currentSpeed - 0.06f, 0.0f);
                    break;
                }
                this.currentSpeed = Math.min(this.currentSpeed + 0.03f, 1.0f);
                float targetRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                m.m_146922_(this.rotlerp(m.m_146908_(), targetRot));
                m.m_7910_((float)(this.f_24978_ * (double)attributeSpeed) * this.currentSpeed);
                m.m_21570_(this.currrentRotate * this.currentSpeed * 1.5f / this.maxRotate);
                BlockPos blockpos = m.m_20183_();
                BlockState blockstate = m.m_9236_().m_8055_(blockpos);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)m.m_9236_(), blockpos);
                if (!(dy > (double)m.getStepHeight() && dx * dx + dz * dz < (double)Math.max(1.0f, m.m_20205_())) && (voxelshape.m_83281_() || !(m.m_20186_() < voxelshape.m_83297_(Direction.Axis.Y) + (double)blockpos.m_123342_()) || blockstate.m_204336_(BlockTags.f_13103_) || blockstate.m_204336_(BlockTags.f_13039_))) break;
                m.m_21569_().m_24901_();
                this.f_24981_ = MoveControl.Operation.JUMPING;
                break;
            }
            case JUMPING: {
                m.m_7910_((float)(this.f_24978_ * (double)attributeSpeed));
                if (!m.m_20096_()) break;
                this.f_24981_ = MoveControl.Operation.WAIT;
                break;
            }
            default: {
                this.currentSpeed = Math.max(this.currentSpeed - 0.06f, 0.0f);
            }
        }
    }

    protected float rotlerp(float p_24992_, float p_24993_) {
        float f = Mth.m_14177_((float)(p_24993_ - p_24992_));
        if (this.currrentRotate > f) {
            this.currrentRotate = Mth.m_14179_((float)this.rotIntensity, (float)this.currrentRotate, (float)Math.max(f, -this.maxRotate));
        }
        if (this.currrentRotate < f) {
            this.currrentRotate = Mth.m_14179_((float)this.rotIntensity, (float)this.currrentRotate, (float)Math.min(f, this.maxRotate));
        }
        this.currentSpeed = Math.max(this.currentSpeed - Math.abs(this.currrentRotate) * 0.003f, 0.0f);
        float f1 = p_24992_ + this.currrentRotate;
        if (f1 < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    private boolean m_24996_(float p_24997_, float p_24998_) {
        NodeEvaluator nodeevaluator;
        PathNavigation pathnavigation = this.f_24974_.m_21573_();
        return pathnavigation == null || (nodeevaluator = pathnavigation.m_26575_()) == null || nodeevaluator.m_8086_((BlockGetter)this.f_24974_.m_9236_(), Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)p_24997_)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)p_24998_))) == BlockPathTypes.WALKABLE;
    }
}

