/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.threateninglymobs;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="threateningly_mobs")
public class SaintbossBar {
    private static final ResourceLocation CUSTOM_BAR_BG = new ResourceLocation("threateningly_mobs", "textures/screens/saintbarframex.png");
    private static final ResourceLocation CUSTOM_BAR_FILL = new ResourceLocation("threateningly_mobs", "textures/screens/saintbarx.png");
    private static int vanillaCounter = 0;

    @SubscribeEvent
    public static void onVanillaBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        ++vanillaCounter;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        int vanillaBars = vanillaCounter;
        vanillaCounter = 0;
        List<LivingEntity> bosses = mc.f_91073_.m_45933_((Entity)mc.f_91074_, mc.f_91074_.m_20191_().m_82400_(50.0)).stream().filter(e -> e.m_6095_().toString().contains("hypocritical_saint")).filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).sorted(Comparator.comparingDouble(e -> e.m_20280_((Entity)mc.f_91074_))).toList();
        if (bosses.isEmpty()) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int screenWidth = mc.m_91268_().m_85445_();
        int barWidth = 160;
        int barHeight = 32;
        int spacing = 5;
        int baseY = 5 + vanillaBars * (barHeight + spacing);
        int maxCustomBars = Math.max(0, 4 - vanillaBars);
        for (int i = 0; i < Math.min(maxCustomBars, bosses.size()); ++i) {
            LivingEntity boss = bosses.get(i);
            float health = boss.m_21223_();
            float maxHealth = boss.m_21233_();
            float progress = Math.max(0.0f, health / maxHealth);
            int x = (screenWidth - barWidth) / 2;
            int y = baseY + i * (barHeight + spacing);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUSTOM_BAR_BG);
            guiGraphics.m_280163_(CUSTOM_BAR_BG, x, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
            int progressWidth = (int)((float)barWidth * progress);
            if (progressWidth <= 0) continue;
            guiGraphics.m_280163_(CUSTOM_BAR_FILL, x, y, 0.0f, 0.0f, progressWidth, barHeight, barWidth, barHeight);
        }
        poseStack.m_85849_();
    }
}

